/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.logging;

import com.nuix.automate.utils.general.SchedulerComponent;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.logging.WorkerLogsWatchService;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.models.internal.logging.LogEventModel;
import com.nuix.automate.utils.models.internal.template.AutomateApplication;
import com.nuix.automate.utils.models.internal.template.AutomateConfiguration;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LogHandler {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(LogHandler.class);
    private AutomateConfiguration automateConfiguration;
    private AutomateApplication automateApplication;
    private static LogHandler instance = new LogHandler();
    private SchedulerComponent schedulerComponent;
    private boolean isRunning;
    private String componentId;
    private String jobId;
    private boolean watchingJob = false;
    private Map<String, Thread> workerWatchers;
    private List<LogEventModel> componentLogs;
    private long totalLogLinesDiscarded;
    private long logLine = 1L;

    private LogHandler() {
        this.isRunning = true;
        this.componentLogs = new ArrayList<LogEventModel>();
        this.workerWatchers = new HashMap<String, Thread>();
    }

    public LogHandler(SchedulerComponent schedulerComponent, String componentId) {
        this.schedulerComponent = schedulerComponent;
        this.componentId = componentId;
        this.componentLogs = new ArrayList<LogEventModel>();
        this.workerWatchers = new HashMap<String, Thread>();
    }

    public static LogHandler getInstance() {
        return instance;
    }

    public void configureInstance(AutomateApplication automateApplication, AutomateConfiguration automateConfiguration) {
        this.automateApplication = automateApplication;
        this.automateConfiguration = automateConfiguration;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public void setComponentId(String id) {
        if (id != null) {
            this.componentId = id;
            this.updateComponentLogsId();
        }
    }

    public void updateLogHandlerComponent() {
        this.schedulerComponent = this.automateConfiguration.getRole();
        switch (this.automateConfiguration.getRole()) {
            case SCHEDULER: 
            case ENGINE_SERVER: {
                this.jobId = null;
                break;
            }
            case ENGINE: {
                this.componentId = this.automateConfiguration.getEngineId();
                this.jobId = this.automateConfiguration.getJobId();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogEvent(LogEventModel event) {
        if (event != null) {
            int componentLogsSize = this.componentLogs.size();
            if (this.automateConfiguration.getCentralizedLoggingMaxActiveLines() <= componentLogsSize) {
                if (this.totalLogLinesDiscarded == 0L) {
                    LOGGER.warn("Discarded log lines: 1. Current log lines in memory: " + componentLogsSize + ". Future related messages will be silenced.");
                }
                ++this.totalLogLinesDiscarded;
            } else {
                List<LogEventModel> list = this.componentLogs;
                synchronized (list) {
                    this.componentLogs.add(event);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillAndAddLogEvent(LogEventModel event) {
        event.setId(this.componentId);
        event.setComponent(this.schedulerComponent.name());
        event.setJobId(this.jobId);
        event.setLogLine(this.logLine);
        int componentLogsSize = this.componentLogs.size();
        if (this.automateConfiguration.getCentralizedLoggingMaxActiveLines() <= componentLogsSize) {
            if (this.totalLogLinesDiscarded == 0L) {
                LOGGER.warn("Discarded log lines: 1. Current log lines in memory: " + componentLogsSize + ". Future related messages will be silenced.");
            }
            ++this.totalLogLinesDiscarded;
        } else {
            List<LogEventModel> list = this.componentLogs;
            synchronized (list) {
                this.componentLogs.add(event);
            }
        }
        ++this.logLine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LogEventModel> removeComponentLogs() {
        ArrayList<LogEventModel> logs;
        List<LogEventModel> list = this.componentLogs;
        synchronized (list) {
            logs = new ArrayList<LogEventModel>(this.componentLogs);
            this.componentLogs.clear();
        }
        if (this.totalLogLinesDiscarded > 0L) {
            LOGGER.warn("Memory log lines cleared. Total discarded log lines: " + this.totalLogLinesDiscarded);
            this.totalLogLinesDiscarded = 0L;
        }
        return logs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLogEvents(List<LogEventModel> logEvents) {
        int newLogLines = logEvents.size();
        if (newLogLines > 0) {
            int totalLogLines = this.componentLogs.size() + newLogLines;
            int componentLogsSize = this.componentLogs.size();
            if (this.automateConfiguration.getCentralizedLoggingMaxActiveLines() < totalLogLines) {
                if (this.totalLogLinesDiscarded == 0L) {
                    LOGGER.warn("Discarded log lines: " + newLogLines + ". Current log lines in memory: " + componentLogsSize + ". Future related messages will be silenced.");
                }
                this.totalLogLinesDiscarded += (long)newLogLines;
            } else {
                List<LogEventModel> list = this.componentLogs;
                synchronized (list) {
                    this.componentLogs.addAll(logEvents);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateComponentLogsId() {
        List<LogEventModel> list = this.componentLogs;
        synchronized (list) {
            for (LogEventModel model : this.componentLogs) {
                model.setId(this.componentId);
            }
        }
    }

    public void updateLogHandler(boolean shouldRun) {
        this.automateConfiguration.setEnableCentralizedLogging(shouldRun);
        if (this.isRunning == shouldRun) {
            return;
        }
        if (shouldRun) {
            this.logLine = 1L;
            this.automateApplication.startCentralizedLoggingAdapter();
        } else {
            this.logLine = 1L;
            this.automateApplication.stopCentralizedLoggingAdapter();
        }
        this.componentLogs.clear();
        this.isRunning = shouldRun;
    }

    public void watchJob() {
        this.watchingJob = true;
    }

    public void removeJobWatch() {
        if (this.workerWatchers.containsKey(this.jobId) && this.workerWatchers.get(this.jobId) != null) {
            this.workerWatchers.get(this.jobId).interrupt();
        }
    }

    public boolean getWatchingJob() {
        return this.watchingJob;
    }

    public void startWorkerWatch(String jobGuid, EngineModel engine) {
        this.watchingJob = false;
        String nuixJobId = jobGuid.replace("-", "");
        Path jobDir = null;
        String logDir = System.getProperty("nuix.logdir");
        jobDir = logDir != null ? Paths.get(logDir, "job-" + nuixJobId) : Paths.get(System.getProperty("user.dir"), "job-" + nuixJobId);
        WorkerLogsWatchService watchService = new WorkerLogsWatchService();
        Thread t = watchService.getThread(jobDir, this.jobId, nuixJobId, engine);
        t.setName("Automate - Worker Log Collector");
        t.start();
        this.workerWatchers.put(this.jobId, t);
    }
}

