/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.logging;

import com.nuix.automate.utils.general.FormattingUtils;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;

public class LoggerWrapper {
    private Logger logger;
    private LinkedHashMap<String, String> recentErrors;
    private AtomicInteger recentErrorsDay;

    public LoggerWrapper(Logger logger, LinkedHashMap<String, String> recentErrors, AtomicInteger recentErrorsDay) {
        this.logger = logger;
        this.recentErrors = recentErrors;
        this.recentErrorsDay = recentErrorsDay;
    }

    public void info(String s) {
        this.logger.info((Object)FormattingUtils.encodeForLog(s));
    }

    private synchronized boolean isStackNew(String s, Throwable t) {
        if (this.recentErrorsDay.get() != DateTime.now().getDayOfYear()) {
            this.logger.info((Object)"Clearing logging cache");
            this.recentErrorsDay.set(DateTime.now().getDayOfYear());
            this.recentErrors.clear();
        }
        String currentStackTrace = ExceptionUtils.getStackTrace((Throwable)t);
        String previousStackTrace = this.recentErrors.get(s);
        if (previousStackTrace != null && previousStackTrace.equals(currentStackTrace)) {
            return false;
        }
        this.recentErrors.put(DateTime.now().getMillis() + "", "test");
        this.recentErrors.put(s, currentStackTrace);
        try {
            while (this.recentErrors.size() > 100) {
                this.logger.debug((Object)("LOGGING - Removing element from buffer with size " + this.recentErrors.size()));
                Iterator<Map.Entry<String, String>> iterator = this.recentErrors.entrySet().iterator();
                iterator.next();
                iterator.remove();
            }
        }
        catch (Exception e) {
            this.logger.warn((Object)"Cannot remove element from exception buffer");
        }
        return true;
    }

    public void info(String s, Throwable t) {
        if (this.isStackNew(s, t)) {
            this.logger.info((Object)FormattingUtils.encodeForLog(s), t);
        } else {
            this.logger.info((Object)(FormattingUtils.encodeForLog(s) + " (^)"));
        }
    }

    public void warn(String s) {
        this.logger.warn((Object)FormattingUtils.encodeForLog(s));
    }

    public void warn(String s, Throwable t) {
        if (this.isStackNew(s, t)) {
            this.logger.warn((Object)FormattingUtils.encodeForLog(s), t);
        } else {
            this.logger.warn((Object)(FormattingUtils.encodeForLog(s) + " (^)"));
        }
    }

    public void error(String s) {
        this.logger.error((Object)FormattingUtils.encodeForLog(s));
    }

    public void error(Throwable t) {
        this.logger.error((Object)t);
    }

    public void error(String s, Throwable t) {
        if (this.isStackNew(s, t)) {
            this.logger.error((Object)s, t);
        } else {
            this.logger.error((Object)(FormattingUtils.encodeForLog(s) + " (^)"));
        }
    }

    public void debug(String s) {
        this.logger.debug((Object)FormattingUtils.encodeForLog(s));
    }

    public void debug(String s, Throwable t) {
        if (this.isStackNew(s, t)) {
            this.logger.debug((Object)FormattingUtils.encodeForLog(s), t);
        } else {
            this.logger.debug((Object)(FormattingUtils.encodeForLog(s) + " (^)"));
        }
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void trace(String s) {
        this.logger.trace((Object)FormattingUtils.encodeForLog(s));
    }

    public void trace(String s, Throwable t) {
        if (this.isStackNew(s, t)) {
            this.logger.trace((Object)FormattingUtils.encodeForLog(s), t);
        } else {
            this.logger.trace((Object)(FormattingUtils.encodeForLog(s) + " (^)"));
        }
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }
}

