/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.apikey;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.api.apikey.ApiKeyWithSecret;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import io.swagger.v3.oas.annotations.media.Schema;

public class ApiKey
extends UserPermissionModel {
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    @Schema(description="Api Key ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Api Key Name", example="Platform A Integration Key")
    private String name;
    @Schema(description="Api Key User")
    private Identifier user;
    @Schema(description="User ID", example="11111111-1111-1111-1111-111111111111")
    private String userId;
    @Schema(description="Validity Days", example="365")
    private int validityDays;
    @Schema(description="Last Used Day (Days Since Epoch)", example="18994")
    private long lastUsedDay;
    @Schema(description="Created Day (Days Since Epoch)", example="18994")
    private long createdDay;
    @Schema(description="Api Key Status")
    private Status status;

    public ApiKey() {
    }

    public ApiKey(ApiKeyWithSecret apiKeyWithSecret) {
        this.id = apiKeyWithSecret.getId();
        this.name = apiKeyWithSecret.getName();
        this.user = apiKeyWithSecret.getUser();
        this.validityDays = apiKeyWithSecret.getValidityDays();
        this.lastUsedDay = apiKeyWithSecret.getLastUsedDay();
        this.createdDay = apiKeyWithSecret.getCreatedDay();
        this.status = apiKeyWithSecret.getStatus();
        this.userId = apiKeyWithSecret.getUserId();
        this.setUserPermissions(apiKeyWithSecret.getUserPermissions());
    }

    @Override
    public ApiKey clone() {
        return (ApiKey)super.clone();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Identifier getUser() {
        return this.user;
    }

    public void setUser(Identifier user) {
        this.user = user;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getValidityDays() {
        return this.validityDays;
    }

    public void setValidityDays(int validityDays) {
        this.validityDays = validityDays;
    }

    public long getLastUsedDay() {
        return this.lastUsedDay;
    }

    public void setLastUsedDay(long lastUsedDay) {
        this.lastUsedDay = lastUsedDay;
    }

    public long getCreatedDay() {
        return this.createdDay;
    }

    public void setCreatedDay(long createdDay) {
        this.createdDay = createdDay;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ApiKey cloneLimited() {
        ApiKey limited = new ApiKey();
        limited.id = this.id;
        limited.name = this.name;
        limited.setUserPermissions(this.cloneUserPermissions());
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        limited.userId = this.userId;
        return limited;
    }
}

