/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.apikey;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import io.swagger.v3.oas.annotations.media.Schema;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class EphemeralApiKeyWithSecret
extends UserPermissionModel {
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    @Schema(description="Api Key ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Api Key Name", example="Platform A Integration Key")
    private String name;
    @Schema(description="Api Key User")
    private Identifier user;
    @Schema(description="User ID", example="11111111-1111-1111-1111-111111111111")
    private String userId;
    @Schema(description="Validity Duration (millis)", example="1000")
    private long validityDuration;
    @Schema(description="Created Date (Epoch)", example="1641034800000")
    private long createdDate;
    @Schema(description="Api Key Secret", example="I7zG7gm1O8EGIbv8bpRA2qYZkJsCBUMM")
    private String secret;

    @Override
    public EphemeralApiKeyWithSecret clone() {
        return (EphemeralApiKeyWithSecret)super.clone();
    }

    public boolean isValid() {
        long age = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() - this.createdDate;
        return age > 0L && age < this.validityDuration;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Identifier getUser() {
        return this.user;
    }

    public void setUser(Identifier user) {
        this.user = user;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public long getValidityDuration() {
        return this.validityDuration;
    }

    public void setValidityDuration(long validityDuration) {
        this.validityDuration = validityDuration;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(long createdDate) {
        this.createdDate = createdDate;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getBearerToken() {
        return this.id + ":" + this.secret;
    }
}

