/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.audit;

import com.nuix.automate.utils.models.internal.event.EventType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import org.joda.time.DateTime;

public class AuditEvent
implements Serializable {
    @Schema(description="Event ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Affected Object ID", example="11111111-1111-1111-1111-111111111111")
    private String affectedId;
    @Schema(description="Event Date (Epoch)", example="1641034800000")
    private Long date;
    @Schema(description="Event Performed By", example="jsmith@example.com")
    private String performedBy;
    @Schema(description="IP Address", example="192.168.0.1")
    private String ipAddress;
    @Schema(description="Event Type")
    private EventType.Type eventType;
    @Schema(description="Legacy Event Type")
    private String legacyEventType;
    @Schema(description="Event Details", example="Description: This is a new description\nEnabled: true")
    private String details;

    public AuditEvent(AuditEvent e) {
        this.id = e.id;
        this.affectedId = e.affectedId;
        this.date = e.date;
        this.performedBy = e.performedBy;
        this.eventType = e.eventType;
        this.legacyEventType = e.legacyEventType;
        this.details = e.details;
        this.ipAddress = e.ipAddress;
    }

    public AuditEvent(String id, String affectedId, Long date, String performedBy, EventType eventType, String details, String ipAddress) {
        this.id = id;
        this.affectedId = affectedId;
        this.date = date;
        this.performedBy = performedBy;
        this.eventType = eventType.getType();
        this.legacyEventType = eventType.getType().name();
        this.details = details;
        this.ipAddress = ipAddress;
    }

    public AuditEvent(String id, String affectedId, Long date, String performedBy, EventType.Type type, String details, String ipAddress) {
        this.id = id;
        this.affectedId = affectedId;
        this.date = date;
        this.performedBy = performedBy;
        this.eventType = type;
        this.legacyEventType = type.name();
        this.details = details;
        this.ipAddress = ipAddress;
    }

    public AuditEvent() {
    }

    public Long getDate() {
        return this.date;
    }

    public void setDate(Long date) {
        this.date = date;
    }

    public String getPerformedBy() {
        return this.performedBy;
    }

    public void setPerformedBy(String performedBy) {
        this.performedBy = performedBy;
    }

    public EventType.Type getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType.Type eventType) {
        this.eventType = eventType;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getAffectedId() {
        return this.affectedId;
    }

    public void setAffectedId(String affectedId) {
        this.affectedId = affectedId;
    }

    public String getLegacyEventType() {
        return this.legacyEventType;
    }

    public void setLegacyEventType(String legacyEventType) {
        this.legacyEventType = legacyEventType;
    }

    public String toString() {
        return new DateTime((Object)this.date).toString() + " " + this.legacyEventType + " " + this.performedBy;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }
}

