/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.client;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ClientPool
extends UserPermissionModel
implements Serializable,
Cloneable {
    @Schema(description="Client Pool ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Client Pool Name", example="Category A Clients")
    private String name;
    @Schema(description="Client Pool Description", example="This client pool is for clients of category A")
    private String description;
    @Schema(description="Client IDs")
    private Set<String> clientIds;
    @Schema(description="Allowed Parameter Values", ref="#/components/schemas/ParametersAllowedValues")
    private Map<String, List<String>> allowedParameterValues;
    @Schema(description="Required Metadata Headers", ref="#/components/schemas/HeadersWithRegex")
    private Map<String, String> requiredMetadataHeaders;
    @Schema(description="Workflow parameters", ref="#/components/schemas/ParametersValue")
    private LinkedHashMap<String, String> workflowParameters;
    @Schema(description="Client Pool Status")
    private Status status;

    @Override
    public ClientPool clone() {
        ClientPool clonedObject = (ClientPool)super.clone();
        clonedObject.allowedParameterValues = new TreeMap<String, List<String>>();
        if (this.allowedParameterValues != null) {
            for (String allowedParameterName : this.allowedParameterValues.keySet()) {
                List<String> allowedValues = this.allowedParameterValues.get(allowedParameterName);
                ArrayList<String> clonedAllowedValues = new ArrayList<String>();
                clonedAllowedValues.addAll(allowedValues);
                clonedObject.allowedParameterValues.put(allowedParameterName, clonedAllowedValues);
            }
        }
        if (this.requiredMetadataHeaders != null) {
            clonedObject.requiredMetadataHeaders = new HashMap<String, String>(this.requiredMetadataHeaders);
        }
        if (this.workflowParameters != null) {
            clonedObject.workflowParameters = new LinkedHashMap<String, String>(this.workflowParameters);
        }
        clonedObject.clientIds = new HashSet<String>();
        if (this.clientIds != null) {
            clonedObject.clientIds.addAll(this.clientIds);
        }
        return clonedObject;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<String> getClientIds() {
        return this.clientIds;
    }

    public void setClientIds(Set<String> clientIds) {
        this.clientIds = clientIds;
    }

    public String toString() {
        return "Client Pool " + this.name;
    }

    public Map<String, List<String>> getAllowedParameterValues() {
        return this.allowedParameterValues;
    }

    public void setAllowedParameterValues(Map<String, List<String>> allowedParameterValues) {
        this.allowedParameterValues = allowedParameterValues;
    }

    public Map<String, String> getRequiredMetadataHeaders() {
        return this.requiredMetadataHeaders;
    }

    public void setRequiredMetadataHeaders(Map<String, String> requiredMetadataHeaders) {
        this.requiredMetadataHeaders = requiredMetadataHeaders;
    }

    public LinkedHashMap<String, String> getWorkflowParameters() {
        return this.workflowParameters;
    }

    public void setWorkflowParameters(LinkedHashMap<String, String> workflowParameters) {
        this.workflowParameters = workflowParameters;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Client Pool " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (this.getClientIds() == null) {
            this.setClientIds(new HashSet<String>());
        }
    }

    public ClientPool cloneLimited() {
        ClientPool limited = new ClientPool();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.setUserPermissions(this.cloneUserPermissions());
        limited.clientIds = new HashSet<String>();
        return limited;
    }
}

