/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.client;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Matter
extends UserPermissionModel
implements Serializable,
Cloneable {
    @Schema(description="Matter ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Matter Name", example="Project Orange")
    private String name;
    @Schema(description="Client ID", example="11111111-1111-1111-1111-111111111111")
    private String clientId;
    @Schema(description="Matter Description", example="This matter has a description")
    private String description;
    @Schema(description="Is Matter Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Default Resource Pool ID", example="11111111-1111-1111-1111-111111111111")
    private String defaultResourcePoolId;
    @Schema(description="Default Execution Profile ID", example="11111111-1111-1111-1111-111111111111")
    private String defaultExecutionProfileId;
    @Schema(description="Reference", example="Internal reference")
    private String reference;
    @Schema(description="Are Jobs Synchronized on Matter?", example="false")
    private Boolean synchronizeJobs;
    @Schema(description="Allowed Parameter Values", ref="#/components/schemas/ParametersAllowedValues")
    private Map<String, List<String>> allowedParameterValues;
    @Schema(description="Required Metadata Headers", ref="#/components/schemas/HeadersWithRegex")
    private Map<String, String> requiredMetadataHeaders;
    @Schema(description="Lifetime Datasets Count", example="5")
    private int datasetCounter;
    @Schema(description="Workflow parameters", ref="#/components/schemas/ParametersValue")
    private LinkedHashMap<String, String> workflowParameters;
    @Schema(description="Matter Status")
    private Status status;

    @Override
    public Matter clone() {
        Matter clonedObject = (Matter)super.clone();
        clonedObject.allowedParameterValues = new TreeMap<String, List<String>>();
        if (this.allowedParameterValues != null) {
            for (String allowedParameterName : this.allowedParameterValues.keySet()) {
                List<String> allowedValues = this.allowedParameterValues.get(allowedParameterName);
                ArrayList<String> clonedAllowedValues = new ArrayList<String>();
                clonedAllowedValues.addAll(allowedValues);
                clonedObject.allowedParameterValues.put(allowedParameterName, clonedAllowedValues);
            }
        }
        if (this.requiredMetadataHeaders != null) {
            clonedObject.requiredMetadataHeaders = new HashMap<String, String>(this.requiredMetadataHeaders);
        }
        clonedObject.workflowParameters = new LinkedHashMap();
        if (this.workflowParameters != null) {
            clonedObject.workflowParameters = new LinkedHashMap<String, String>(this.workflowParameters);
        }
        return clonedObject;
    }

    public void normalizeRequiredMetadataHeaders() {
        HashMap<String, String> normalizedMap = new HashMap<String, String>();
        if (this.requiredMetadataHeaders != null) {
            for (String key : this.requiredMetadataHeaders.keySet()) {
                if (key.trim().length() <= 0) continue;
                normalizedMap.put(key, this.requiredMetadataHeaders.get(key));
            }
        }
        this.setRequiredMetadataHeaders(normalizedMap);
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDefaultResourcePoolId() {
        return this.defaultResourcePoolId;
    }

    public void setDefaultResourcePoolId(String defaultResourcePoolId) {
        this.defaultResourcePoolId = defaultResourcePoolId;
    }

    public String getDefaultExecutionProfileId() {
        return this.defaultExecutionProfileId;
    }

    public void setDefaultExecutionProfileId(String defaultExecutionProfileId) {
        this.defaultExecutionProfileId = defaultExecutionProfileId;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public Boolean getSynchronizeJobs() {
        return this.synchronizeJobs;
    }

    public void setSynchronizeJobs(Boolean synchronizeJobs) {
        this.synchronizeJobs = synchronizeJobs;
    }

    public Map<String, List<String>> getAllowedParameterValues() {
        return this.allowedParameterValues;
    }

    public void setAllowedParameterValues(Map<String, List<String>> allowedParameterValues) {
        this.allowedParameterValues = allowedParameterValues;
    }

    public int getDatasetCounter() {
        return this.datasetCounter;
    }

    public void setDatasetCounter(int datasetCounter) {
        this.datasetCounter = datasetCounter;
    }

    public Map<String, String> getRequiredMetadataHeaders() {
        return this.requiredMetadataHeaders;
    }

    public void setRequiredMetadataHeaders(Map<String, String> requiredMetadataHeaders) {
        this.requiredMetadataHeaders = requiredMetadataHeaders;
    }

    public LinkedHashMap<String, String> getWorkflowParameters() {
        return this.workflowParameters;
    }

    public void setWorkflowParameters(LinkedHashMap<String, String> workflowParameters) {
        this.workflowParameters = workflowParameters;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Matter " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (this.getEnabled() == null) {
            this.setEnabled(false);
        }
    }

    public Matter cloneLimited() {
        Matter limited = new Matter();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.enabled = this.enabled;
        limited.clientId = this.clientId;
        limited.setUserPermissions(this.cloneUserPermissions());
        return limited;
    }
}

