/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.dataset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.models.api.dataset.AzureStorageAccount;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.DatasetType;
import com.nuix.automate.utils.models.internal.dataset.UsableSpace;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;

public class DataRepository
extends UserPermissionModel
implements Serializable,
Cloneable {
    private boolean limited;
    @Schema(description="Data Repository ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Data Repository Type")
    private DatasetType type;
    @Schema(description="Data Repository Name", example="Storage A")
    private String name;
    @Schema(description="Data Repository Description", example="Fast and large storage")
    private String description;
    @Schema(description="Data Repository Azure Storage Account")
    private AzureStorageAccount azureStorageAccount;
    @Schema(description="Data Repository Path", example="\\Storage.local\\RepoA")
    private String path;
    @Schema(description="Is Quota Enabled?", example="true")
    private Boolean quotaEnabled;
    @Schema(description="Quota (Bytes)", example="52147483647")
    private Long quota;
    @Schema(description="Is Dataset Max Size Enabled?", example="true")
    private Boolean datasetMaxSizeEnabled;
    @Schema(description="Dataset Max Size (Bytes)", example="52147483647")
    private Long datasetMaxSize;
    @Schema(description="Is Upload Max Size Enabled?", example="true")
    private Boolean uploadMaxSizeEnabled;
    @Schema(description="Upload Max Size (Bytes)", example="52147483647")
    private Long uploadMaxSize;
    @Schema(description="Compute Usable Space?", example="true")
    private Boolean computeFileSystemUsableSpace;
    @Schema(description="Usable Space")
    private UsableSpace usableSpace;
    @Schema(description="Allowed File Extensions", example="[\"pdf\",\"docx\"]")
    private Set<String> allowedFileExtensions;
    @Schema(description="Auto-Expire Interval (Milliseconds)", example="52147483647")
    private Long datasetAutoExpireInterval;
    @Schema(description="Is Auto-Hide Enabled?", example="true")
    private Boolean datasetAutoHide;
    @Schema(description="Is Auto-Expire on Job Ended With No Errors or Warnings Enabled?", example="true")
    private Boolean datasetAutoArchive;
    @Schema(description="Is Auto-Archive on Job Ended with Errors Enabled?", example="true")
    private Boolean datasetAutoArchiveJobError;
    @Schema(description="Is Auto-Archive on Job Ended with Soft Errors Enabled?", example="true")
    private Boolean datasetAutoArchiveJobSoftError;
    @Schema(description="Is Auto-Archive on Job Ended With Warnings Enabled?", example="true")
    private Boolean datasetAutoArchiveJobWarning;
    @Schema(description="Data Repository Status")
    private Status status;

    @Override
    public DataRepository clone() {
        DataRepository clone = (DataRepository)super.clone();
        if (this.azureStorageAccount != null) {
            clone.setAzureStorageAccount(this.azureStorageAccount.clone());
        }
        return clone;
    }

    @JsonIgnore
    public boolean isCompatible(Dataset dataset) {
        if (this.type != dataset.getType() && (dataset.getType() != DatasetType.ECC || this.type != DatasetType.MANAGED)) {
            return false;
        }
        if (this.type == DatasetType.IN_PLACE) {
            return this.containsPath(dataset.getPath());
        }
        return true;
    }

    @JsonIgnore
    public boolean containsPath(String path) {
        if (path == null) {
            return false;
        }
        Path repositoryPath = Paths.get(this.path, new String[0]).normalize().toAbsolutePath();
        Path parentPath = Paths.get(path, new String[0]).normalize().toAbsolutePath().getParent();
        return parentPath != null && parentPath.startsWith(repositoryPath);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public DatasetType getType() {
        return this.type;
    }

    public void setType(DatasetType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public AzureStorageAccount getAzureStorageAccount() {
        return this.azureStorageAccount;
    }

    public void setAzureStorageAccount(AzureStorageAccount azureStorageAccount) {
        this.azureStorageAccount = azureStorageAccount;
    }

    public String getPath() {
        if (this.path != null) {
            return this.path.trim();
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Boolean getQuotaEnabled() {
        return this.quotaEnabled;
    }

    public void setQuotaEnabled(Boolean quotaEnabled) {
        this.quotaEnabled = quotaEnabled;
    }

    public Long getQuota() {
        return this.quota;
    }

    public void setQuota(Long quota) {
        this.quota = quota;
    }

    public Boolean getDatasetMaxSizeEnabled() {
        return this.datasetMaxSizeEnabled;
    }

    public void setDatasetMaxSizeEnabled(Boolean datasetMaxSizeEnabled) {
        this.datasetMaxSizeEnabled = datasetMaxSizeEnabled;
    }

    public Long getDatasetMaxSize() {
        return this.datasetMaxSize;
    }

    public void setDatasetMaxSize(Long datasetMaxSize) {
        this.datasetMaxSize = datasetMaxSize;
    }

    public Boolean getUploadMaxSizeEnabled() {
        return this.uploadMaxSizeEnabled;
    }

    public void setUploadMaxSizeEnabled(Boolean uploadMaxSizeEnabled) {
        this.uploadMaxSizeEnabled = uploadMaxSizeEnabled;
    }

    public Long getUploadMaxSize() {
        return this.uploadMaxSize;
    }

    public void setUploadMaxSize(Long uploadMaxSize) {
        this.uploadMaxSize = uploadMaxSize;
    }

    public Boolean getComputeFileSystemUsableSpace() {
        return this.computeFileSystemUsableSpace;
    }

    public void setComputeFileSystemUsableSpace(Boolean computeFileSystemUsableSpace) {
        this.computeFileSystemUsableSpace = computeFileSystemUsableSpace;
    }

    public UsableSpace getUsableSpace() {
        return this.usableSpace;
    }

    public void setUsableSpace(UsableSpace usableSpace) {
        this.usableSpace = usableSpace;
    }

    public Set<String> getAllowedFileExtensions() {
        return this.allowedFileExtensions;
    }

    public void setAllowedFileExtensions(Set<String> allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions;
    }

    public Long getDatasetAutoExpireInterval() {
        return this.datasetAutoExpireInterval;
    }

    public void setDatasetAutoExpireInterval(Long datasetAutoExpireInterval) {
        this.datasetAutoExpireInterval = datasetAutoExpireInterval;
    }

    public Boolean getDatasetAutoHide() {
        return this.datasetAutoHide;
    }

    public void setDatasetAutoHide(Boolean datasetAutoHide) {
        this.datasetAutoHide = datasetAutoHide;
    }

    public Boolean getDatasetAutoArchive() {
        return this.datasetAutoArchive;
    }

    public void setDatasetAutoArchive(Boolean datasetAutoArchive) {
        this.datasetAutoArchive = datasetAutoArchive;
    }

    public Boolean getDatasetAutoArchiveJobError() {
        return this.datasetAutoArchiveJobError;
    }

    public void setDatasetAutoArchiveJobError(Boolean datasetAutoArchiveJobError) {
        this.datasetAutoArchiveJobError = datasetAutoArchiveJobError;
    }

    public Boolean getDatasetAutoArchiveJobSoftError() {
        return this.datasetAutoArchiveJobSoftError;
    }

    public void setDatasetAutoArchiveJobSoftError(Boolean datasetAutoArchiveJobSoftError) {
        this.datasetAutoArchiveJobSoftError = datasetAutoArchiveJobSoftError;
    }

    public Boolean getDatasetAutoArchiveJobWarning() {
        return this.datasetAutoArchiveJobWarning;
    }

    public void setDatasetAutoArchiveJobWarning(Boolean datasetAutoArchiveJobWarning) {
        this.datasetAutoArchiveJobWarning = datasetAutoArchiveJobWarning;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Data Repository " + this.getId());
        }
        if (this.getType() == null) {
            this.setType(DatasetType.MANAGED);
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (this.getQuotaEnabled() == null) {
            this.setQuotaEnabled(false);
        }
        if (this.getDatasetMaxSizeEnabled() == null) {
            this.setDatasetMaxSizeEnabled(false);
        }
        if (this.getUploadMaxSizeEnabled() == null) {
            this.setUploadMaxSizeEnabled(false);
        }
        if (this.getDatasetAutoArchive() == null) {
            this.setDatasetAutoArchive(false);
        }
        if (this.getDatasetAutoArchiveJobError() == null) {
            this.setDatasetAutoArchiveJobError(false);
        }
        if (this.getDatasetAutoArchiveJobSoftError() == null) {
            this.setDatasetAutoArchiveJobSoftError(false);
        }
        if (this.getDatasetAutoArchiveJobWarning() == null) {
            this.setDatasetAutoArchiveJobWarning(false);
        }
        if (this.getDatasetAutoHide() == null) {
            this.setDatasetAutoHide(false);
        }
    }

    public DataRepository cloneLimited() {
        DataRepository limited = new DataRepository();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.setUserPermissions(this.cloneUserPermissions());
        limited.type = this.type;
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        return limited;
    }
}

