/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.dataset;

import com.nuix.automate.utils.general.InternationalizationUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;

public class DataRepositoryFile {
    private static final transient InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    private String path;
    private String name;
    private long lastModified;
    private Long size;
    private int fileCount;
    private boolean directory;
    private boolean aggregate;

    public DataRepositoryFile() {
    }

    public DataRepositoryFile(Path path) throws IOException {
        BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        this.path = path.toAbsolutePath().toString();
        this.name = path.getFileName().toString();
        this.lastModified = attr.lastModifiedTime().toMillis();
        this.directory = attr.isDirectory();
        if (!this.directory) {
            this.size = attr.size();
        }
    }

    public void addFile(BasicFileAttributes attr) {
        if (attr.lastModifiedTime().toMillis() > this.lastModified) {
            this.lastModified = attr.lastModifiedTime().toMillis();
        }
        this.size = this.size == null ? Long.valueOf(attr.size()) : Long.valueOf(this.size + attr.size());
        ++this.fileCount;
    }

    public void generateName() {
        this.name = iu.getNumeralString("DataRepositoryResource.AggregateFileName", this.fileCount);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public Long getSize() {
        return this.size;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }

    public boolean getDirectory() {
        return this.directory;
    }

    public void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean getAggregate() {
        return this.aggregate;
    }

    public void setAggregate(boolean aggregate) {
        this.aggregate = aggregate;
    }
}

