/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.dataset;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.models.api.dataset.DatasetPathFormat;
import com.nuix.automate.utils.models.api.dataset.DatasetState;
import com.nuix.automate.utils.models.api.dataset.DatasetType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;

public class Dataset
extends UserPermissionModel
implements Cloneable {
    @Schema(description="Dataset ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Matter ID", example="11111111-1111-1111-1111-111111111111")
    private String matterId;
    @Schema(description="Dataset Name", example="Upload 1")
    private String name;
    @Schema(description="Dataset Description", example="Data uploaded by custodian")
    private String description;
    @Schema(description="Data Repository ID", example="11111111-1111-1111-1111-111111111111")
    private String dataRepositoryId;
    @Schema(description="Dataset Path", example="\\Storage.local\\Dataset 01")
    private String path;
    @Schema(description="Dataset State")
    private DatasetState state = DatasetState.DRAFT;
    @Schema(description="Data Number")
    private Integer number;
    @Schema(description="Dataset Created (Epoch)", example="1641034800000")
    private Long createdDate;
    @Schema(description="Dataset Last Modified (Epoch)", example="1641034800000")
    private Long lastModifiedDate;
    @Schema(description="Dataset Finalized (Epoch)", example="1641034800000")
    private Long finalizedDate;
    @Schema(description="Dataset Archived Date (Epoch)", example="1641034800000")
    private Long archivedDate;
    @Schema(description="Usable Space")
    private Long usableSpace;
    @Schema(description="Require Metadata Headers")
    private List<String> fileMetadataHeaders;
    @Schema(description="Dataset Custodian", example="jsmith@example.com")
    private String datasetCustodian;
    @Schema(description="Collection ID", example="11111111-1111-1111-1111-111111111111")
    private String collectionId;
    @Schema(description="Collection Target ID", example="11111111-1111-1111-1111-111111111111")
    private String collectionTargetId;
    @Schema(description="Notice ID", example="11111111-1111-1111-1111-111111111111")
    private String noticeEventId;
    @Schema(description="Dataset Type")
    private DatasetType type;
    @Schema(description="Dataset Path Format")
    private DatasetPathFormat pathFormat;

    @Override
    public Dataset clone() {
        Dataset clone = (Dataset)super.clone();
        if (this.fileMetadataHeaders != null) {
            clone.setFileMetadataHeaders(new ArrayList<String>(this.fileMetadataHeaders));
        }
        return clone;
    }

    public void takeSpace(long size) {
        if (this.usableSpace != null) {
            this.usableSpace = this.usableSpace - size;
        }
    }

    @JsonIgnore
    public boolean isDraft() {
        return this.state == DatasetState.DRAFT;
    }

    @JsonIgnore
    public boolean isFinalized() {
        return this.state == DatasetState.FINALIZED;
    }

    @JsonIgnore
    public boolean isArchived() {
        return this.state == DatasetState.ARCHIVED;
    }

    @JsonIgnore
    public boolean isHidden() {
        return this.state == DatasetState.HIDDEN;
    }

    @JsonIgnore
    public boolean isExpired() {
        return this.state == DatasetState.EXPIRED;
    }

    @JsonIgnore
    public boolean isDeleted() {
        return this.state == DatasetState.DELETED;
    }

    @JsonIgnore
    public boolean isActiveCollection() {
        return this.state == DatasetState.ACTIVE_COLLECTION;
    }

    public String getMatterId() {
        return this.matterId;
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name.trim();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDataRepositoryId() {
        return this.dataRepositoryId;
    }

    public void setDataRepositoryId(String dataRepositoryId) {
        this.dataRepositoryId = dataRepositoryId;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public DatasetState getState() {
        return this.state;
    }

    public void setState(DatasetState state) {
        this.state = state;
    }

    public List<String> getFileMetadataHeaders() {
        return this.fileMetadataHeaders;
    }

    public void setFileMetadataHeaders(List<String> fileMetadataHeaders) {
        this.fileMetadataHeaders = fileMetadataHeaders;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.number = number;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public Long getFinalizedDate() {
        return this.finalizedDate;
    }

    public void setFinalizedDate(Long finalizedDate) {
        this.finalizedDate = finalizedDate;
    }

    public Long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public Long getArchivedDate() {
        return this.archivedDate;
    }

    public void setArchivedDate(Long archivedDate) {
        this.archivedDate = archivedDate;
    }

    public Long getUsableSpace() {
        return this.usableSpace;
    }

    public void setUsableSpace(Long usableSpace) {
        this.usableSpace = usableSpace;
    }

    public String getDatasetCustodian() {
        return this.datasetCustodian;
    }

    public void setDatasetCustodian(String datasetCustodian) {
        this.datasetCustodian = datasetCustodian;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public String getCollectionTargetId() {
        return this.collectionTargetId;
    }

    public void setCollectionTargetId(String collectionTargetId) {
        this.collectionTargetId = collectionTargetId;
    }

    public String getNoticeEventId() {
        return this.noticeEventId;
    }

    public void setNoticeEventId(String noticeEventId) {
        this.noticeEventId = noticeEventId;
    }

    public DatasetType getType() {
        return this.type;
    }

    public void setType(DatasetType type) {
        this.type = type;
    }

    public DatasetPathFormat getPathFormat() {
        return this.pathFormat;
    }

    public void setPathFormat(DatasetPathFormat pathFormat) {
        this.pathFormat = pathFormat;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Data Set " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (this.getType() == null) {
            this.setType(DatasetType.MANAGED);
        }
    }

    public Dataset cloneLimited() {
        Dataset limited = new Dataset();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.matterId = this.matterId;
        limited.setUserPermissions(this.cloneUserPermissions());
        return limited;
    }
}

