/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.dataset;

import com.nuix.automate.utils.models.api.client.Matter;
import com.nuix.automate.utils.models.api.dataset.Dataset;
import com.nuix.automate.utils.models.api.dataset.FileInfo;

public class FileUploadHistory {
    private String id;
    private String clientId;
    private String matterId;
    private String datasetId;
    private String dataRepositoryId;
    private String username;
    private String clientIpAddresses;
    private String serverIpAddress;
    private String serverName;
    private String serverRole;
    private int fileCount;
    private int interruptedCount;
    private long size;
    private long uploadDuration;

    public FileUploadHistory(FileInfo fileInfo, Dataset dataset, Matter matter) {
        this.username = fileInfo.getAddedBy();
        this.clientIpAddresses = fileInfo.getClientIpAddresses();
        this.serverIpAddress = fileInfo.getServerIpAddress();
        this.serverName = fileInfo.getServerName();
        this.serverRole = fileInfo.getServerRole();
        this.clientId = matter.getClientId();
        this.matterId = matter.getId();
        this.datasetId = dataset.getId();
        this.dataRepositoryId = dataset.getDataRepositoryId();
        this.id = FileUploadHistory.computeUniqueKey(fileInfo, dataset, matter);
    }

    public void addFileInfo(FileInfo fileInfo) {
        ++this.fileCount;
        this.size += fileInfo.getSize();
        this.interruptedCount += fileInfo.getInterruptedCount();
        this.uploadDuration += fileInfo.getUploadDuration();
    }

    public static String computeUniqueKey(FileInfo info, Dataset dataset, Matter matter) {
        return info.getAddedBy() + info.getClientIpAddresses() + info.getServerIpAddress() + info.getServerName() + info.getServerRole() + matter.getClientId() + matter.getId() + dataset.getId() + dataset.getDataRepositoryId();
    }

    public String computeUniqueKey() {
        return this.username + '-' + this.clientIpAddresses + '-' + this.serverIpAddress + '-' + this.serverName + '-' + this.serverRole;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getMatterId() {
        return this.matterId;
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId;
    }

    public String getDatasetId() {
        return this.datasetId;
    }

    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    public String getDataRepositoryId() {
        return this.dataRepositoryId;
    }

    public void setDataRepositoryId(String dataRepositoryId) {
        this.dataRepositoryId = dataRepositoryId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getClientIpAddresses() {
        return this.clientIpAddresses;
    }

    public void setClientIpAddresses(String clientIpAddresses) {
        this.clientIpAddresses = clientIpAddresses;
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }

    public void setServerIpAddress(String serverIpAddress) {
        this.serverIpAddress = serverIpAddress;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getServerRole() {
        return this.serverRole;
    }

    public void setServerRole(String serverRole) {
        this.serverRole = serverRole;
    }

    public int getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(int fileCount) {
        this.fileCount = fileCount;
    }

    public int getInterruptedCount() {
        return this.interruptedCount;
    }

    public void setInterruptedCount(int interruptedCount) {
        this.interruptedCount = interruptedCount;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getUploadDuration() {
        return this.uploadDuration;
    }

    public void setUploadDuration(long uploadDuration) {
        this.uploadDuration = uploadDuration;
    }
}

