/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.engine;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.LocalizedEnum;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.engine.EngineStatus;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.models.internal.engine.EngineModel;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.workflow.ExecutionMode;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Engine
extends UserPermissionModel
implements Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Engine.class);
    @Schema(description="Engine ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Engine Name", example="Processing Engine A")
    private String name;
    @Schema(description="Server ID", example="11111111-1111-1111-1111-111111111111")
    private String serverId;
    @Schema(description="Nuix License Source ID", example="11111111-1111-1111-1111-111111111111")
    private String nuixLicenceSourceId;
    @Schema(description="Execution Profile ID", example="11111111-1111-1111-1111-111111111111")
    private String executionProfileId;
    @Schema(description="Engine Target Workers Count", example="4")
    private Integer targetNuixWorkers;
    @Schema(description="Engine Minimum Workers Count", example="2")
    private Integer minNuixWorkers;
    @Schema(description="Engine Acquired Workers Count", example="4")
    private Integer acquiredWorkers;
    @Schema(description="Nuix Version", example="9.0.0")
    private String nuixVersion;
    @Schema(description="Java Version", example="Eclipse Foundation 11.0.12+7 OpenJDK 64-Bit Server VM")
    private String javaVersion;
    @Schema(description="Nuix License Type", example="enterprise-workstation")
    private String nuixLicenceType;
    @Schema(description="Engine Status")
    private EngineStatus status;
    @Schema(description="Engine Error Message", example="Sample error message")
    private String error;
    @Schema(description="Engine Error Timestamp (Epoch)", example="1641034800000")
    private long errorTime;
    @Schema(description="Execution Percentage Completion", example="17.25")
    private Double runningJobPercentageComplete;
    @Schema(description="Engine Priority")
    private Priority priority;
    @Schema(description="Job ID", example="11111111-1111-1111-1111-111111111111")
    private String runningJobId;
    @Schema(description="Log File Location", example="\\\\Storage\\Logs\\engine-a.log")
    private String logFile;
    @Schema(description="Is Engine Operating As Remote Workers?", example="false")
    private boolean workerAgentOnly;
    @Schema(description="Engine Tags", ref="#/components/schemas/Tags")
    private Map<String, String> tags;
    @Schema(description="Engine Current Execution Mode")
    private ExecutionMode currentExecutionMode;
    @Schema(description="Engine Supported Execution Mode")
    private ExecutionMode supportedExecutionMode;

    public ExecutionMode getSupportedExecutionMode() {
        return this.supportedExecutionMode;
    }

    public void setSupportedExecutionMode(ExecutionMode supportedExecutionMode) {
        this.supportedExecutionMode = supportedExecutionMode;
    }

    public Engine(EngineModel copy) {
        this.id = copy.getId();
        this.name = copy.getName();
        this.serverId = copy.getServerId();
        this.nuixLicenceSourceId = copy.getNuixLicenceSourceId();
        this.executionProfileId = copy.getExecutionProfileId();
        this.targetNuixWorkers = copy.getTargetNuixWorkers();
        this.minNuixWorkers = copy.getMinNuixWorkers();
        this.acquiredWorkers = copy.getAcquiredWorkers();
        this.nuixVersion = copy.getNuixVersion();
        this.javaVersion = copy.getJavaVersion();
        this.status = copy.getStatus();
        this.priority = copy.getPriority();
        this.error = copy.getError();
        this.nuixLicenceType = copy.getNuixLicenceType();
        this.runningJobPercentageComplete = copy.getRunningJobPercentageComplete();
        this.runningJobId = copy.getRunningJobId();
        this.logFile = copy.getLogFile();
        this.workerAgentOnly = copy.getWorkerAgentOnly();
        this.tags = new HashMap<String, String>();
        if (copy.getTags() != null) {
            this.tags.putAll(copy.getTags());
        }
        this.currentExecutionMode = copy.getCurrentExecutionMode();
        this.supportedExecutionMode = copy.getSupportedExecutionMode();
    }

    public long getErrorTime() {
        return this.errorTime;
    }

    public void setErrorTime() {
        this.errorTime = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis();
    }

    public Engine() {
    }

    public String getNuixLicenceType() {
        return this.nuixLicenceType;
    }

    public void setNuixLicenceType(String nuixLicenceType) {
        this.nuixLicenceType = nuixLicenceType;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Double getRunningJobPercentageComplete() {
        return this.runningJobPercentageComplete;
    }

    public void setRunningJobPercentageComplete(Double runningJobPercentageComplete) {
        this.runningJobPercentageComplete = runningJobPercentageComplete;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty
    public Integer getTargetNuixWorkers() {
        return this.targetNuixWorkers;
    }

    @JsonProperty
    public void setTargetNuixWorkers(Integer targetNuixWorkers) {
        this.targetNuixWorkers = targetNuixWorkers;
    }

    @JsonProperty
    public Integer getMinNuixWorkers() {
        if (this.minNuixWorkers == null) {
            return this.targetNuixWorkers;
        }
        return this.minNuixWorkers;
    }

    @JsonProperty
    public void setMinNuixWorkers(Integer minNuixWorkers) {
        this.minNuixWorkers = minNuixWorkers;
    }

    @JsonProperty
    public String getNuixVersion() {
        return this.nuixVersion;
    }

    @JsonProperty
    public void setEngineVersion(String nuixVersion) {
        this.nuixVersion = nuixVersion;
    }

    public Integer getAcquiredWorkers() {
        return this.acquiredWorkers;
    }

    public void setAcquiredWorkers(Integer acquiredWorkers) {
        this.acquiredWorkers = acquiredWorkers;
    }

    @JsonProperty
    public void setNuixVersion(String nuixVersion) {
        this.nuixVersion = nuixVersion;
    }

    public EngineStatus getStatus() {
        return this.status;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public synchronized void appendErrorLine(String line) {
        this.error = this.error == null || this.error.length() == 0 ? line : this.error + "\n" + line;
    }

    public void setStatus(EngineStatus status) {
        this.status = status;
        if (status == EngineStatus.ERROR || status == EngineStatus.WARNING) {
            this.setErrorTime();
        }
    }

    public String toString() {
        return "Engine " + this.getName() + (this.workerAgentOnly ? "[WorkerOnly]" : "") + " (" + new LocalizedEnum<EngineStatus>("SchedulerText", this.getStatus()) + ")";
    }

    public String getNuixLicenceSourceId() {
        return this.nuixLicenceSourceId;
    }

    public void setNuixLicenceSourceId(String nuixLicenceSourceId) {
        this.nuixLicenceSourceId = nuixLicenceSourceId;
    }

    public String getExecutionProfileId() {
        return this.executionProfileId;
    }

    public void setExecutionProfileId(String executionProfileId) {
        this.executionProfileId = executionProfileId;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getRunningJobId() {
        return this.runningJobId;
    }

    public void setRunningJobId(String runningJobId) {
        this.runningJobId = runningJobId;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public boolean getWorkerAgentOnly() {
        return this.workerAgentOnly;
    }

    public void setWorkerAgentOnly(boolean workerAgentOnly) {
        this.workerAgentOnly = workerAgentOnly;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public ExecutionMode getCurrentExecutionMode() {
        return this.currentExecutionMode;
    }

    public void setCurrentExecutionMode(ExecutionMode currentExecutionMode) {
        this.currentExecutionMode = currentExecutionMode;
    }

    public Engine cloneLimited() {
        Engine limited = new Engine();
        limited.id = this.id;
        limited.name = this.name;
        limited.serverId = this.serverId;
        if (this.error != null && this.error.length() > 0) {
            limited.error = FormattingUtils.constantToCamelCaseFirstUpper("ERROR") + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + this.error);
        }
        limited.errorTime = this.errorTime;
        limited.setUserPermissions(this.cloneUserPermissions());
        limited.status = this.status;
        limited.currentExecutionMode = this.currentExecutionMode;
        limited.supportedExecutionMode = this.supportedExecutionMode;
        return limited;
    }
}

