/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.filelibrary;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.models.api.filelibrary.FileLibraryFile;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class FileLibrary
extends UserPermissionModel
implements Serializable,
Cloneable {
    @Schema(description="File Library ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="File Library Name", example="Sample File Library")
    private String name;
    @Schema(description="File Library Description", example="Sample description")
    private String description;
    @Schema(description="File Library Created By", example="jsmith@example.com")
    private String createdBy;
    @Schema(description="File Library Created Date (Epoch)", example="1641034800000")
    private long createdDate;
    @Schema(description="File Library Last Changed Date (Epoch)", example="1641034800000")
    private long lastStateChangedDate;
    @Schema(description="Library File Details")
    private Map<String, FileLibraryFile> files;

    @Override
    public FileLibrary clone() {
        FileLibrary clonedObject = (FileLibrary)super.clone();
        clonedObject.files = new HashMap<String, FileLibraryFile>();
        if (this.files != null) {
            for (Map.Entry<String, FileLibraryFile> entry : this.files.entrySet()) {
                clonedObject.files.put(entry.getKey(), entry.getValue().clone());
            }
        }
        return clonedObject;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(long createdDate) {
        this.createdDate = createdDate;
    }

    public long getLastStateChangedDate() {
        return this.lastStateChangedDate;
    }

    public void setLastStateChangedDate(long lastStateChangedDate) {
        this.lastStateChangedDate = lastStateChangedDate;
    }

    public Map<String, FileLibraryFile> getFiles() {
        return this.files;
    }

    public void setFiles(Map<String, FileLibraryFile> files) {
        this.files = files;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FileLibrary cloneLimited() {
        FileLibrary limited = new FileLibrary();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.setUserPermissions(this.cloneUserPermissions());
        return limited;
    }
}

