/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.filelibrary;

import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class FileLibraryFile
implements Serializable,
Cloneable {
    @Schema(description="Library File ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="File Library ID", example="11111111-1111-1111-1111-111111111111")
    private String fileLibraryId;
    @Schema(description="Library File Name", example="Sample File Library")
    private String name;
    @Schema(description="Library File Description", example="Sample description")
    private String description;
    @Schema(description="File Size", example="0")
    private long size;
    @Schema(description="Library File Created By", example="jsmith@example.com")
    private String createdBy;
    @Schema(description="Library File Created Date (Epoch)", example="1641034800000")
    private long createdDate;
    @Schema(description="Library File Last Changed Date (Epoch)", example="1641034800000")
    private long lastStateChangedDate;
    @Schema(description="Library File Type")
    private String fileType;
    @Schema(description="Library File Nuix Type")
    private LibraryNuixFileType nuixFileType;
    @Schema(description="File Data")
    private String data;
    @Schema(description="Library File Audit Log")
    private List<AuditEvent> auditLog;
    @Schema(description="Library File Version")
    private int version;

    public FileLibraryFile clone() {
        try {
            FileLibraryFile clonedObject = (FileLibraryFile)super.clone();
            clonedObject.setAuditLog(new ArrayList<AuditEvent>());
            if (this.auditLog != null) {
                clonedObject.auditLog.addAll(this.auditLog);
            }
            return clonedObject;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getFileType() {
        return this.fileType;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(long createdDate) {
        this.createdDate = createdDate;
    }

    public long getLastStateChangedDate() {
        return this.lastStateChangedDate;
    }

    public void setLastStateChangedDate(long lastStateChangedDate) {
        this.lastStateChangedDate = lastStateChangedDate;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getFileLibraryId() {
        return this.fileLibraryId;
    }

    public void setFileLibraryId(String fileLibraryId) {
        this.fileLibraryId = fileLibraryId;
    }

    public LibraryNuixFileType getNuixFileType() {
        return this.nuixFileType;
    }

    public void setNuixFileType(LibraryNuixFileType nuixFileType) {
        this.nuixFileType = nuixFileType;
    }

    public List<AuditEvent> getAuditLog() {
        return this.auditLog;
    }

    public void setAuditLog(List<AuditEvent> auditLog) {
        this.auditLog = auditLog;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

