/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.job;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.general.ExecutionParameter;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.comment.UserComment;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.models.internal.job.JobModel;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.LinkLog;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Job
extends UserPermissionModel
implements Serializable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Job.class);
    @Schema(description="Job ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Matter ID", example="11111111-1111-1111-1111-111111111111")
    private String matterId;
    @Schema(description="Matter Name", example="Project Lemon")
    private String matterName;
    @Schema(description="Matter Reference", example="Internal Reference Lemon")
    private String matterReference;
    @Schema(description="Client ID", example="11111111-1111-1111-1111-111111111111")
    private String clientId;
    @Schema(description="Client Name", example="Citrus Foods")
    private String clientName;
    @Schema(description="Client Reference", example="Internal Reference Citrus")
    private String clientReference;
    @Schema(description="Engine ID", example="11111111-1111-1111-1111-111111111111")
    private String engineId;
    @Schema(description="Does Engine Have Warnings?", example="false")
    private boolean engineHasWarnings;
    @Schema(description="Is Job Missing Required Profiles?", example="false")
    private boolean missingRequiredProfiles;
    @Schema(description="Is Job Pending Approval?", example="false")
    private boolean inStaging;
    @Schema(description="Automatically Promote From Staging on Date (Epoch)", example="1641034800000")
    private Long autoSubmitOnDate;
    @Schema(description="Engine Name", example="Engine 1")
    private String engineName;
    @Schema(description="Server ID", example="11111111-1111-1111-1111-111111111111")
    private String serverId;
    @Schema(description="Server Name", example="Server 1")
    private String serverName;
    @Schema(description="Execution Profile ID", example="11111111-1111-1111-1111-111111111111")
    private String executionProfileId;
    @Schema(description="Execution Profile Name", example="Profile 1")
    private String executionProfileName;
    @Schema(description="Resource Pool ID", example="11111111-1111-1111-1111-111111111111")
    private String resourcePoolId;
    @Schema(description="Resource Pool Name", example="Pool 1")
    private String resourcePoolName;
    @Schema(description="Last resource Pool ID", example="11111111-1111-1111-1111-111111111111")
    private String lastResourcePoolId;
    @Schema(description="Job Priority")
    private Priority priority;
    @Schema(description="Job Staged By", example="jsmith@example.com")
    private String stagedBy;
    @Schema(description="Job Submitted By", example="jsmith@example.com")
    private String submittedBy;
    @Schema(description="Job Last Modified By", example="jsmith@example.com")
    private String modifiedBy;
    @Schema(description="Job Start Date (Epoch)", example="1641034800000")
    private Long startedDate;
    @Schema(description="Job Ended Date (Epoch)", example="1641034800000")
    private Long finishedDate;
    @Schema(description="Job Staged Date (Epoch)", example="1641034800000")
    private Long stagedDate;
    @Schema(description="Job Submitted Date (Epoch)", example="1641034800000")
    private Long submittedDate;
    @Schema(description="Job Resubmitted Date (Epoch)", example="1641034800000")
    private Long resubmittedDate;
    @Schema(description="Job Last Changed Date (Epoch)", example="1641034800000")
    private Long lastStateChangedDate;
    @Schema(description="Job Name", example="Job 1")
    private String name;
    @Schema(description="Workflow ID", example="11111111-1111-1111-1111-111111111111")
    private String libraryWorkflowId;
    @Schema(description="Workflow Name", example="Standard Processing Workflow")
    private String libraryWorkflowName;
    @Schema(description="Library ID", example="11111111-1111-1111-1111-111111111111")
    private String libraryId;
    @Schema(description="Library Name", example="Default Library")
    private String libraryName;
    @Schema(description="Job Notes", example="This is a Job submitted using the API")
    private String notes;
    @Schema(description="Execution State")
    private ExecutionState executionState;
    @Schema(description="Job Error Message", example="Sample error message")
    private String error;
    @Schema(description="Job Soft Error Messages")
    private List<String> softErrors;
    @Schema(description="Job Warning Messages")
    private List<String> warnings;
    @Schema(description="Job Informational Messages")
    private List<String> infos;
    @Schema(description="Job Links")
    private List<LinkLog> links;
    @Schema(description="Job Parameters")
    private List<Parameter> sessionParameters;
    @Schema(description="Execution Parameters")
    private List<ExecutionParameter> executionParameters;
    @Schema(description="Execution Percentage Completion", example="17.25")
    private double percentageComplete;
    @Schema(description="Does Job Have Warnings?", example="false")
    private boolean hasWarnings;
    @Schema(description="Does Job Have Soft Errors?", example="false")
    private boolean hasSoftErrors;
    @Schema(description="Schedule ID", example="11111111-1111-1111-1111-111111111111")
    private String scheduleId;
    @Schema(description="Schedule Name", example="Weekly Processing")
    private String scheduleName;
    @Schema(description="Is Utilization Excluded?", example="false")
    private boolean excludeUtilization;
    @Schema(description="Running Operation ID", example="7")
    private Integer runningOperationId;
    @Schema(description="Is Job Waiting for Parameter Lock?", example="false")
    private boolean parameterLock;
    @Schema(description="Is Job Waiting for Matter Lock?", example="false")
    private boolean matterLock;
    @Schema(description="Remote Worker Agent IDs")
    private List<String> workerAgentIds;
    @Schema(description="Last User Comment")
    private UserComment lastUserComment;
    @Schema(description="Current Operation Processing Speed", example="1.50 GB/h")
    private String currentOperationProcessingSpeedText;
    private static final List<ExecutionState> backlogExecutionStates = Arrays.asList(ExecutionState.NOT_STARTED, ExecutionState.PENDING, ExecutionState.PAUSED);

    public Job() {
    }

    public Job(JobModel o, boolean maskProtectedParameters) {
        this.id = o.getId();
        this.engineId = o.getEngineId();
        this.engineName = o.getEngineName();
        this.serverId = o.getServerId();
        this.serverName = o.getServerName();
        this.resourcePoolId = o.getResourcePoolId();
        this.resourcePoolName = o.getResourcePoolName();
        this.lastResourcePoolId = o.getLastResourcePoolId();
        this.executionProfileId = o.getExecutionProfileId();
        this.executionProfileName = o.getExecutionProfileName();
        this.priority = o.getPriority();
        this.stagedBy = o.getStagedBy();
        this.submittedBy = o.getSubmittedBy();
        this.modifiedBy = o.getModifiedBy();
        this.submittedDate = o.getSubmittedDate();
        this.stagedDate = o.getStagedDate();
        this.startedDate = o.getStartedDate();
        this.finishedDate = o.getFinishedDate();
        this.lastStateChangedDate = o.getLastStateChangedDate();
        this.resubmittedDate = o.getResubmittedDate();
        this.engineHasWarnings = o.getEngineHasWarnings();
        this.missingRequiredProfiles = o.getMissingRequiredProfiles();
        this.inStaging = o.getInStaging();
        this.autoSubmitOnDate = o.getAutoSubmitOnDate();
        this.scheduleId = o.getScheduleId();
        this.excludeUtilization = o.getExcludeUtilization();
        this.matterLock = o.getMatterLock();
        this.parameterLock = o.getParameterLock();
        this.workerAgentIds = o.getWorkerAgentIds();
        this.runningOperationId = o.getRunningOperationId();
        this.notes = o.getNotes();
        this.error = o.getError();
        this.matterId = o.getMatterId();
        this.matterName = o.getMatterName();
        this.matterReference = o.getMatterReference();
        this.clientId = o.getClientId();
        this.clientName = o.getClientName();
        this.clientReference = o.getClientReference();
        this.name = o.getName();
        this.libraryWorkflowId = o.getLibraryWorkflowId();
        this.libraryId = o.getLibraryId();
        this.executionState = o.getExecutionState();
        this.softErrors = new ArrayList<String>();
        this.warnings = new ArrayList<String>();
        this.infos = new ArrayList<String>();
        this.links = new ArrayList<LinkLog>();
        if (o.getSoftErrors() != null) {
            this.softErrors.addAll(o.getSoftErrors());
        }
        if (o.getWarnings() != null) {
            this.warnings.addAll(o.getWarnings());
        }
        if (o.getInfos() != null) {
            this.infos.addAll(o.getInfos());
        }
        if (o.getLinks() != null) {
            this.links.addAll(o.getLinks());
        }
        this.executionParameters = new ArrayList<ExecutionParameter>();
        if (o.getExecutionParameters() != null) {
            this.executionParameters.addAll(o.getExecutionParameters());
        }
        this.sessionParameters = new ArrayList<Parameter>();
        if (o.getSessionParameters() != null) {
            for (Parameter oParameterModel : o.getSessionParameters()) {
                Parameter newParameterModel = new Parameter(oParameterModel);
                if (maskProtectedParameters && (newParameterModel.isProtected() || newParameterModel.isMasked()) && (newParameterModel.getValue() == null || newParameterModel.getValue().length() > 0)) {
                    newParameterModel.setValue(null);
                }
                this.sessionParameters.add(newParameterModel);
            }
        }
        this.percentageComplete = o.getPercentageComplete();
        if (o.getHasWarnings() != null) {
            this.hasWarnings = o.getHasWarnings();
        }
        this.hasSoftErrors = o.getHasSoftErrors() == Boolean.TRUE;
        this.currentOperationProcessingSpeedText = o.getCurrentOperationProcessingSpeedText();
        this.calculateBacklogJobHasWarnings();
    }

    private void calculateBacklogJobHasWarnings() {
        if (backlogExecutionStates.contains((Object)this.executionState)) {
            this.hasWarnings = this.hasWarnings || this.resourcePoolId == null || this.resourcePoolName == null || this.executionProfileId == null || this.executionProfileName == null || this.engineHasWarnings || this.missingRequiredProfiles;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMatterId() {
        return this.matterId;
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId;
    }

    public String getMatterName() {
        return this.matterName;
    }

    public void setMatterName(String matterName) {
        this.matterName = matterName;
    }

    public String getMatterReference() {
        return this.matterReference;
    }

    public void setMatterReference(String matterReference) {
        this.matterReference = matterReference;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getClientReference() {
        return this.clientReference;
    }

    public void setClientReference(String clientReference) {
        this.clientReference = clientReference;
    }

    public String getEngineId() {
        return this.engineId;
    }

    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    public boolean getEngineHasWarnings() {
        return this.engineHasWarnings;
    }

    public void setEngineHasWarnings(boolean engineHasWarnings) {
        this.engineHasWarnings = engineHasWarnings;
    }

    public boolean getMissingRequiredProfiles() {
        return this.missingRequiredProfiles;
    }

    public void setMissingRequiredProfiles(boolean missingRequiredProfiles) {
        this.missingRequiredProfiles = missingRequiredProfiles;
    }

    public boolean getInStaging() {
        return this.inStaging;
    }

    public void setInStaging(boolean inStaging) {
        this.inStaging = inStaging;
    }

    public Long getAutoSubmitOnDate() {
        return this.autoSubmitOnDate;
    }

    public void setAutoSubmitOnDate(Long autoSubmitOnDate) {
        this.autoSubmitOnDate = autoSubmitOnDate;
    }

    public String getEngineName() {
        return this.engineName;
    }

    public void setEngineName(String engineName) {
        this.engineName = engineName;
    }

    public String getServerId() {
        return this.serverId;
    }

    public void setServerId(String serverId) {
        this.serverId = serverId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getExecutionProfileId() {
        return this.executionProfileId;
    }

    public void setExecutionProfileId(String executionProfileId) {
        this.executionProfileId = executionProfileId;
    }

    public String getExecutionProfileName() {
        return this.executionProfileName;
    }

    public void setExecutionProfileName(String executionProfileName) {
        this.executionProfileName = executionProfileName;
    }

    public String getResourcePoolId() {
        return this.resourcePoolId;
    }

    public void setResourcePoolId(String resourcePoolId) {
        this.resourcePoolId = resourcePoolId;
    }

    public String getResourcePoolName() {
        return this.resourcePoolName;
    }

    public void setResourcePoolName(String resourcePoolName) {
        this.resourcePoolName = resourcePoolName;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public String getSubmittedBy() {
        return this.submittedBy;
    }

    public void setSubmittedBy(String submittedBy) {
        this.submittedBy = submittedBy;
    }

    public String getStagedBy() {
        return this.stagedBy;
    }

    public void setStagedBy(String stagedBy) {
        this.stagedBy = stagedBy;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    public Long getStartedDate() {
        return this.startedDate;
    }

    public void setStartedDate(Long startedDate) {
        this.startedDate = startedDate;
    }

    public Long getFinishedDate() {
        return this.finishedDate;
    }

    public void setFinishedDate(Long finishedDate) {
        this.finishedDate = finishedDate;
    }

    public Long getSubmittedDate() {
        return this.submittedDate;
    }

    public void setSubmittedDate(Long submittedDate) {
        this.submittedDate = submittedDate;
    }

    public Long getStagedDate() {
        return this.stagedDate;
    }

    public void setStagedDate(Long stagedDate) {
        this.stagedDate = stagedDate;
    }

    public Long getResubmittedDate() {
        return this.resubmittedDate;
    }

    public void setResubmittedDate(Long resubmittedDate) {
        this.resubmittedDate = resubmittedDate;
    }

    public Long getLastStateChangedDate() {
        return this.lastStateChangedDate;
    }

    public void setLastStateChangedDate(Long lastStateChangedDate) {
        this.lastStateChangedDate = lastStateChangedDate;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLibraryWorkflowId() {
        return this.libraryWorkflowId;
    }

    public void setLibraryWorkflowId(String libraryWorkflowId) {
        this.libraryWorkflowId = libraryWorkflowId;
    }

    public String getLibraryWorkflowName() {
        return this.libraryWorkflowName;
    }

    public void setLibraryWorkflowName(String libraryWorkflowName) {
        this.libraryWorkflowName = libraryWorkflowName;
    }

    public String getLibraryId() {
        return this.libraryId;
    }

    public void setLibraryId(String libraryId) {
        this.libraryId = libraryId;
    }

    public String getLibraryName() {
        return this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public List<String> getSoftErrors() {
        return this.softErrors;
    }

    public void setSoftErrors(List<String> softErrors) {
        this.softErrors = softErrors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public List<String> getInfos() {
        return this.infos;
    }

    public void setInfos(List<String> infos) {
        this.infos = infos;
    }

    public List<LinkLog> getLinks() {
        return this.links;
    }

    public void setLinks(List<LinkLog> links) {
        this.links = links;
    }

    public List<Parameter> getSessionParameters() {
        return this.sessionParameters;
    }

    public void setSessionParameters(List<Parameter> sessionParameters) {
        this.sessionParameters = sessionParameters;
    }

    public double getPercentageComplete() {
        return this.percentageComplete;
    }

    public void setPercentageComplete(double percentageComplete) {
        this.percentageComplete = percentageComplete;
    }

    public boolean getHasWarnings() {
        return this.hasWarnings;
    }

    public void setHasWarnings(boolean hasWarnings) {
        this.hasWarnings = hasWarnings;
    }

    public boolean getHasSoftErrors() {
        return this.hasSoftErrors;
    }

    public void setHasSoftErrors(boolean hasSoftErrors) {
        this.hasSoftErrors = hasSoftErrors;
    }

    public String getScheduleId() {
        return this.scheduleId;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    public boolean isExcludeUtilization() {
        return this.excludeUtilization;
    }

    public void setExcludeUtilization(boolean excludeUtilization) {
        this.excludeUtilization = excludeUtilization;
    }

    public Integer getRunningOperationId() {
        return this.runningOperationId;
    }

    public void setRunningOperationId(Integer runningOperationId) {
        this.runningOperationId = runningOperationId;
    }

    public String getScheduleName() {
        return this.scheduleName;
    }

    public void setScheduleName(String scheduleName) {
        this.scheduleName = scheduleName;
    }

    public boolean isParameterLock() {
        return this.parameterLock;
    }

    public void setParameterLock(boolean parameterLock) {
        this.parameterLock = parameterLock;
    }

    public boolean isMatterLock() {
        return this.matterLock;
    }

    public void setMatterLock(boolean matterLock) {
        this.matterLock = matterLock;
    }

    public List<String> getWorkerAgentIds() {
        if (this.workerAgentIds == null) {
            this.workerAgentIds = new ArrayList<String>();
        }
        return this.workerAgentIds;
    }

    public void setWorkerAgentIds(List<String> workerAgentIds) {
        this.workerAgentIds = workerAgentIds;
    }

    public String getLastResourcePoolId() {
        return this.lastResourcePoolId;
    }

    public void setLastResourcePoolId(String lastResourcePoolId) {
        this.lastResourcePoolId = lastResourcePoolId;
    }

    public List<ExecutionParameter> getExecutionParameters() {
        return this.executionParameters;
    }

    public void setExecutionParameters(List<ExecutionParameter> executionParameters) {
        this.executionParameters = executionParameters;
    }

    public UserComment getLastUserComment() {
        return this.lastUserComment;
    }

    public void setLastUserComment(UserComment lastUserComment) {
        this.lastUserComment = lastUserComment;
    }

    public String getCurrentOperationProcessingSpeedText() {
        return this.currentOperationProcessingSpeedText;
    }

    public void setCurrentOperationProcessingSpeedText(String currentOperationProcessingSpeedText) {
        this.currentOperationProcessingSpeedText = currentOperationProcessingSpeedText;
    }

    public Job cloneLimited() {
        Job limited = new Job();
        limited.id = this.id;
        limited.name = this.name;
        limited.clientId = this.clientId;
        limited.setUserPermissions(this.cloneUserPermissions());
        limited.matterId = this.matterId;
        limited.clientId = this.clientId;
        limited.engineHasWarnings = this.engineHasWarnings;
        limited.inStaging = this.inStaging;
        limited.priority = this.priority;
        limited.startedDate = this.startedDate;
        limited.finishedDate = this.finishedDate;
        limited.stagedDate = this.stagedDate;
        limited.submittedDate = this.submittedDate;
        limited.resubmittedDate = this.resubmittedDate;
        limited.lastStateChangedDate = this.lastStateChangedDate;
        limited.name = this.name;
        limited.libraryWorkflowId = this.libraryWorkflowId;
        limited.libraryId = this.libraryId;
        limited.executionState = this.executionState;
        if (this.error != null && this.error.length() > 0) {
            limited.error = FormattingUtils.constantToCamelCaseFirstUpper("ERROR") + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + this.error);
        }
        limited.softErrors = new ArrayList<String>();
        if (this.softErrors != null) {
            for (String string : this.softErrors) {
                limited.softErrors.add(FormattingUtils.constantToCamelCaseFirstUpper("ERROR") + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + string));
            }
        }
        limited.warnings = new ArrayList<String>();
        if (this.warnings != null) {
            for (String string : this.warnings) {
                limited.warnings.add(FormattingUtils.constantToCamelCaseFirstUpper("WARNING") + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + string));
            }
        }
        limited.infos = new ArrayList<String>();
        if (this.infos != null) {
            for (String string : this.infos) {
                limited.infos.add(string);
            }
        }
        limited.links = new ArrayList<LinkLog>();
        if (this.links != null) {
            for (LinkLog linkLog : this.links) {
                limited.links.add(linkLog);
            }
        }
        limited.percentageComplete = this.percentageComplete;
        limited.hasWarnings = this.hasWarnings;
        limited.hasSoftErrors = this.hasSoftErrors;
        limited.runningOperationId = this.runningOperationId;
        limited.executionProfileId = this.executionProfileId;
        limited.resourcePoolId = this.resourcePoolId;
        limited.priority = this.priority;
        limited.executionParameters = new ArrayList<ExecutionParameter>();
        limited.sessionParameters = new ArrayList<Parameter>();
        return limited;
    }
}

