/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.job;

import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.job.Job;
import com.nuix.automate.utils.models.api.job.OperationStatus;
import com.nuix.automate.utils.models.internal.job.JobDetailsModel;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class JobDetails
implements Serializable {
    @Schema(description="Settings")
    private Job settings;
    @Schema(description="Operations")
    private List<OperationStatus> operations;
    @Schema(description="Audit Log")
    private List<AuditEvent> auditLog;
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(JobDetails.class);

    public List<OperationStatus> getOperations() {
        return this.operations;
    }

    public void setOperations(List<OperationStatus> operations) {
        this.operations = operations;
    }

    public void setSettings(Job settings) {
        this.settings = settings;
    }

    public Job getSettings() {
        return this.settings;
    }

    public List<AuditEvent> getAuditLog() {
        if (this.auditLog == null) {
            this.auditLog = new ArrayList<AuditEvent>();
        }
        return this.auditLog;
    }

    public void setAuditLog(List<AuditEvent> auditLog) {
        this.auditLog = auditLog;
    }

    public JobDetails() {
    }

    public JobDetails(JobDetailsModel original) {
        this(original, false);
    }

    public JobDetails(JobDetailsModel original, boolean maskProtectedParameters) {
        this.operations = new ArrayList<OperationStatus>();
        List<OperationStatus> originalOperations = original.getOperations();
        if (originalOperations != null) {
            for (OperationStatus originalOperation : originalOperations) {
                OperationStatus copyOperation = new OperationStatus(originalOperation);
                this.operations.add(copyOperation);
            }
        }
        this.auditLog = new ArrayList<AuditEvent>();
        List<AuditEvent> originalEventLog = original.getAuditLog();
        if (originalEventLog != null) {
            this.auditLog.addAll(originalEventLog);
        }
        this.settings = new Job(original.getSettings(), maskProtectedParameters);
        for (OperationStatus operationStatus : this.operations) {
            if (operationStatus.getWarnings() != null && operationStatus.getWarnings().size() > 0) {
                this.settings.setHasWarnings(true);
            }
            if (operationStatus.hasSoftErrors()) {
                this.settings.setHasSoftErrors(true);
            }
            if (!this.settings.getHasWarnings() || !this.settings.getHasSoftErrors()) continue;
            break;
        }
    }

    public String toString() {
        return this.settings.toString();
    }
}

