/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.job;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.nuix.automate.utils.models.api.filelibrary.LibraryNuixFileType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class JobRequiredProfile
implements Serializable {
    @Schema(description="File Name", example="Profile.xml")
    private String name;
    @Schema(description="Profile Type")
    private LibraryNuixFileType profileType;
    @Schema(description="Is profile missing?", example="true")
    private boolean missing;

    public JobRequiredProfile() {
    }

    public JobRequiredProfile(String name, LibraryNuixFileType profileType) {
        this.name = name;
        this.profileType = profileType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public LibraryNuixFileType getProfileType() {
        return this.profileType;
    }

    public void setProfileType(LibraryNuixFileType profileType) {
        this.profileType = profileType;
    }

    @JsonProperty(value="missing")
    public boolean getMissing() {
        return this.missing;
    }

    public void setMissing(boolean missing) {
        this.missing = missing;
    }

    public void setMissing(Map<LibraryNuixFileType, Set<String>> requiredProfiles) {
        this.missing = !requiredProfiles.get(this.profileType).contains(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JobRequiredProfile that = (JobRequiredProfile)o;
        return Objects.equals(this.name, that.name) && this.profileType == that.profileType;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.profileType);
    }
}

