/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.job;

import com.google.gson.annotations.JsonAdapter;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.general.PrintableOptionAdapter;
import com.nuix.automate.utils.security.SecurityUtils;
import com.nuix.automate.utils.ui.OperationAlias;
import com.nuix.automate.utils.workflow.ExecutionState;
import com.nuix.automate.utils.workflow.PrintableOption;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class OperationStatus
implements Serializable {
    @Schema(description="Job ID", example="11111111-1111-1111-1111-111111111111")
    private String jobId;
    @Schema(description="Operation Workflow Position", example="1")
    private int workflowPosition;
    @Schema(description="Operation Execution Position", example="1")
    private int executionPosition;
    @Schema(description="Operation Notes", example="Sample notes for the operation")
    private String notes;
    @Schema(description="Operation Alias")
    private OperationAlias operationAlias;
    @Schema(description="Operation Name", example="Add Evidence")
    private String name;
    @Schema(description="Operation Options")
    @JsonAdapter(value=PrintableOptionAdapter.class)
    private List<PrintableOption> options;
    private ExecutionState executionState;
    @Schema(description="Execution Percentage Completion", example="17.25")
    private double percentageComplete;
    @Schema(description="Operation Progress", example="12,523 items ...")
    private String progressText;
    @Schema(description="Processing Speed", example="1.50 GB/h")
    private String processingSpeedText;
    @Schema(description="Audited Size (bytes)", example="1500000000")
    private Long auditedSize;
    @Schema(description="Operation Start Date (Epoch)", example="1641034800000")
    private Long startedDate;
    @Schema(description="Operation Estimated Completion Date (Epoch)", example="1641034800000")
    private Long eta;
    @Schema(description="Operation Ended Date (Epoch)", example="1641034800000")
    private Long finishedDate;
    @Schema(description="Operation Warning Messages")
    private List<String> warnings;
    @Schema(description="Operation Error Message", example="Sample error message")
    private String error;
    @Schema(description="Does Operation Use Workers?", example="false")
    private boolean usesWorkers;
    @Schema(description="Is Operation Skippable?", example="false")
    private boolean skippable;
    @Schema(description="Worker Memory", example="2000")
    private Integer workerMemory;
    @Schema(description="Added Worker Count", example="4")
    private Integer addedWorkerCount;
    @Schema(description="Maximum Workers", example="10")
    private Integer maximumWorkerCount;

    public OperationStatus() {
    }

    public OperationStatus(OperationStatus original) {
        this.operationAlias = original.operationAlias;
        this.name = original.name;
        this.notes = original.notes;
        this.options = original.options;
        this.executionState = original.executionState;
        this.percentageComplete = original.percentageComplete;
        if (Double.isNaN(this.percentageComplete)) {
            this.percentageComplete = 0.0;
        }
        this.progressText = original.progressText;
        this.eta = original.eta;
        this.startedDate = original.startedDate;
        this.finishedDate = original.finishedDate;
        this.executionPosition = original.executionPosition;
        this.workflowPosition = original.workflowPosition;
        this.jobId = original.jobId;
        this.warnings = new ArrayList<String>();
        this.warnings.addAll(original.warnings);
        this.error = original.error;
        this.usesWorkers = original.usesWorkers;
        this.skippable = original.skippable;
        this.auditedSize = original.auditedSize;
        this.processingSpeedText = original.processingSpeedText;
        this.workerMemory = original.workerMemory;
        this.addedWorkerCount = original.addedWorkerCount;
        this.maximumWorkerCount = original.maximumWorkerCount;
    }

    public boolean hasSoftErrors() {
        return this.executionState == ExecutionState.SOFT_ERROR && this.error != null && this.error.trim().length() > 0;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public OperationAlias getOperationAlias() {
        return this.operationAlias;
    }

    public void setOperationAlias(OperationAlias operationAlias) {
        this.operationAlias = operationAlias;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setExecutionState(ExecutionState executionState) {
        this.executionState = executionState;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public Long getEta() {
        return this.eta;
    }

    public void setEta(Long eta) {
        this.eta = eta;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<String> warnings) {
        this.warnings = warnings;
    }

    public double getPercentageComplete() {
        if (Double.isNaN(this.percentageComplete)) {
            return 0.0;
        }
        return this.percentageComplete;
    }

    public void setPercentageComplete(double percentageComplete) {
        this.percentageComplete = Double.isNaN(percentageComplete) ? 0.0 : percentageComplete;
    }

    public String getProgressText() {
        return this.progressText;
    }

    public void setProgressText(String progressText) {
        this.progressText = progressText;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public List<PrintableOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<PrintableOption> options) {
        this.options = options;
    }

    public boolean getUsesWorkers() {
        return this.usesWorkers;
    }

    public void setUsesWorkers(boolean usesWorkers) {
        this.usesWorkers = usesWorkers;
    }

    public boolean getSkippable() {
        return this.skippable;
    }

    public void setSkippable(boolean skippable) {
        this.skippable = skippable;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public int getWorkflowPosition() {
        return this.workflowPosition;
    }

    public void setWorkflowPosition(int workflowPosition) {
        this.workflowPosition = workflowPosition;
    }

    public int getExecutionPosition() {
        return this.executionPosition;
    }

    public void setExecutionPosition(int executionPosition) {
        this.executionPosition = executionPosition;
    }

    public Long getStartedDate() {
        return this.startedDate;
    }

    public void setStartedDate(Long startedDate) {
        this.startedDate = startedDate;
    }

    public Long getFinishedDate() {
        return this.finishedDate;
    }

    public void setFinishedDate(Long finishedDate) {
        this.finishedDate = finishedDate;
    }

    public String getProcessingSpeedText() {
        return this.processingSpeedText;
    }

    public void setProcessingSpeedText(String speed) {
        this.processingSpeedText = speed;
    }

    public Long getAuditedSize() {
        return this.auditedSize;
    }

    public void setAuditedSize(Long auditedSize) {
        this.auditedSize = auditedSize;
    }

    public Integer getWorkerMemory() {
        return this.workerMemory;
    }

    public void setWorkerMemory(Integer workerMemory) {
        this.workerMemory = workerMemory;
    }

    public Integer getAddedWorkerCount() {
        return this.addedWorkerCount;
    }

    public void setAddedWorkerCount(Integer addedWorkerCount) {
        this.addedWorkerCount = addedWorkerCount;
    }

    public Integer getMaximumWorkerCount() {
        return this.maximumWorkerCount;
    }

    public void setMaximumWorkerCount(Integer maximumWorkerCount) {
        this.maximumWorkerCount = maximumWorkerCount;
    }

    public String toString() {
        return "OperationStatus{name='" + this.name + '\'' + '}';
    }

    public OperationStatus cloneLimited() {
        OperationStatus limited = new OperationStatus();
        limited.name = this.name;
        limited.jobId = this.jobId;
        limited.workflowPosition = this.workflowPosition;
        limited.executionPosition = this.executionPosition;
        limited.name = this.name;
        limited.operationAlias = this.operationAlias;
        limited.executionState = this.executionState;
        limited.percentageComplete = this.percentageComplete;
        limited.startedDate = this.startedDate;
        limited.eta = this.eta;
        limited.finishedDate = this.finishedDate;
        limited.warnings = new ArrayList<String>();
        if (this.warnings != null) {
            for (String message : this.warnings) {
                limited.warnings.add(FormattingUtils.constantToCamelCaseFirstUpper("WARNING") + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + message));
            }
        }
        if (this.error != null && this.error.length() > 0) {
            limited.error = FormattingUtils.constantToCamelCaseFirstUpper("ERROR") + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + this.error);
        }
        return limited;
    }
}

