/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.job;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.exceptions.ParameterException;
import com.nuix.automate.utils.logging.LogManagerUtils;
import com.nuix.automate.utils.logging.LoggerWrapper;
import com.nuix.automate.utils.workflow.DisplayCondition;
import com.nuix.automate.utils.workflow.ParameterSource;
import com.nuix.automate.utils.workflow.ParameterType;
import com.nuix.automate.utils.workflow.ParameterValueMatchBy;
import com.nuix.automate.utils.workflow.RelativityCondition;
import com.nuix.automate.utils.workflow.ScriptLanguage;
import com.nuix.automate.utils.workflow.StaticParameter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class Parameter
implements Serializable,
Cloneable {
    private static final LoggerWrapper LOGGER = LogManagerUtils.getLogger(Parameter.class);
    @Schema(description="Parameter Mame", example="{sample_param}")
    private String name;
    @Schema(description="Parameter Friendly Name", example="Sample Parameter")
    private String friendlyName;
    @Schema(description="Parameter Value", example="Value1234")
    private String value;
    @Schema(description="Accept multiple values")
    private boolean multiValue;
    @Schema(description="Parameter User Displayable Value", example="Value 1234")
    private String userDisplayableValue;
    @Schema(description="Parameter Description", example="This is a sample parameter")
    private String description;
    @Schema(description="Parameter Regex", example="\\w+")
    private String regex;
    @Schema(description="Parameter Allowed Values Match By")
    private ParameterValueMatchBy allowedValuesMatchBy;
    @Schema(description="Parameter Allowed Values")
    private LinkedHashSet<String> allowedValues;
    @Schema(description="Parameter Min Value", example="0")
    private String min;
    @Schema(description="Parameter Max Value", example="99")
    private String max;
    @Schema(description="Parameter Type")
    private ParameterType parameterType;
    @Schema(description="Display Condition")
    private DisplayCondition displayCondition;
    @Schema(description="Relativity Condition")
    private RelativityCondition relativityCondition;
    @Schema(description="Dependant Parameters")
    private LinkedHashSet<String> dependantParameters;
    @Schema(description="Script Language")
    private ScriptLanguage scriptLanguage;
    @Schema(description="Script Code")
    private String scriptCode;
    @Schema(description="Use Scripted Library File")
    private boolean useLibraryFile;
    @Schema(description="Scripted Library File ID")
    private String libraryFileId;
    @Schema(description="Data Repository ID")
    private String dataRepositoryId;
    @Schema(description="Allowed File Extensions")
    protected Set<String> allowedFileExtensions;
    @Schema(description="Allowed Data Repository IDs")
    protected Set<String> allowedDataRepositoryIds;
    @Schema(description="Source")
    private ParameterSource source;

    public Parameter() {
    }

    public Parameter(Parameter o) {
        this.name = o.name;
        this.friendlyName = o.friendlyName;
        this.value = o.value;
        this.userDisplayableValue = o.userDisplayableValue;
        this.description = o.description;
        this.regex = o.regex;
        this.allowedValuesMatchBy = o.allowedValuesMatchBy;
        if (o.allowedValues != null) {
            this.allowedValues = new LinkedHashSet<String>(o.allowedValues);
        }
        this.min = o.min;
        this.max = o.max;
        this.parameterType = o.parameterType;
        this.displayCondition = o.displayCondition;
        this.relativityCondition = o.relativityCondition;
        if (o.dependantParameters != null) {
            this.dependantParameters = new LinkedHashSet<String>(o.dependantParameters);
        }
        this.scriptLanguage = o.scriptLanguage;
        this.scriptCode = o.scriptCode;
        this.multiValue = o.multiValue;
        this.useLibraryFile = o.useLibraryFile;
        this.libraryFileId = o.libraryFileId;
        this.dataRepositoryId = o.dataRepositoryId;
        this.allowedFileExtensions = o.allowedFileExtensions;
        this.allowedDataRepositoryIds = o.allowedDataRepositoryIds;
        this.source = o.source;
    }

    public Parameter(String name, String value) {
        this.name = name;
        this.value = value;
        this.friendlyName = this.getFriendlyName();
        this.normalize();
    }

    public Parameter(Parameter p1, Parameter p2) {
        this(p1);
        if (p2.getAllowedValues() != null) {
            if (this.allowedValues != null) {
                this.allowedValues.addAll(p2.getAllowedValues());
            } else {
                this.allowedValues = new LinkedHashSet<String>(p2.getAllowedValues());
            }
        }
    }

    public Parameter clone() {
        try {
            Parameter clone = (Parameter)super.clone();
            if (this.allowedValues != null) {
                clone.allowedValues = new LinkedHashSet<String>(this.allowedValues);
            }
            if (this.dependantParameters != null) {
                clone.dependantParameters = new LinkedHashSet<String>(this.dependantParameters);
            }
            clone.displayCondition = this.getDisplayCondition().clone();
            clone.relativityCondition = this.getRelativityCondition().clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Parameter(com.nuix.automate.utils.workflow.Parameter parameter) {
        this.name = parameter.getName();
        this.friendlyName = parameter.getFriendlyName();
        this.userDisplayableValue = parameter.getUserDisplayableValue();
        try {
            this.value = parameter.getProtectedValue();
        }
        catch (ParameterException e) {
            this.value = "";
        }
        this.description = parameter.getDescription();
        this.regex = parameter.getRegex();
        this.allowedValuesMatchBy = parameter.getAllowedValuesMatchBy();
        if (parameter.getAllowedValues() != null) {
            this.allowedValues = new LinkedHashSet<String>(parameter.getAllowedValues());
        }
        this.min = parameter.getMin();
        this.max = parameter.getMax();
        this.parameterType = parameter.getEffectiveParameterType();
        this.displayCondition = parameter.getDisplayCondition();
        this.relativityCondition = parameter.getRelativityCondition();
        if (parameter.getDependantParameters() != null) {
            this.dependantParameters = new LinkedHashSet<String>(parameter.getDependantParameters());
        }
        this.scriptLanguage = parameter.getScriptLanguage();
        this.scriptCode = parameter.getScriptCode();
        this.multiValue = parameter.getMultiValue();
        this.useLibraryFile = parameter.isUseLibraryFile();
        this.libraryFileId = parameter.getLibraryFileId();
        this.dataRepositoryId = parameter.getDataRepositoryId();
        this.allowedFileExtensions = parameter.getAllowedFileExtensions();
        this.allowedDataRepositoryIds = parameter.getAllowedDataRepositoryIds();
        this.source = parameter.getSource();
        this.normalize();
    }

    public ParameterType getParameterType() {
        this.normalize();
        return this.parameterType;
    }

    public void setParameterType(ParameterType parameterType) {
        this.parameterType = parameterType;
    }

    @JsonIgnore
    public boolean isProtected() {
        return this.getParameterType().equals((Object)ParameterType.TEXT_PROTECTED);
    }

    @JsonIgnore
    public boolean isMasked() {
        return this.getParameterType().equals((Object)ParameterType.TEXT_MASKED);
    }

    @JsonIgnore
    public boolean isServerFile() {
        return this.getParameterType().equals((Object)ParameterType.SERVER_FILE);
    }

    @JsonIgnore
    public boolean isServerFolder() {
        return this.getParameterType().equals((Object)ParameterType.SERVER_FOLDER);
    }

    @JsonIgnore
    public boolean isDataSet() {
        return this.getParameterType().equals((Object)ParameterType.DATA_SET);
    }

    @JsonIgnore
    public boolean isRelativityService() {
        return this.getParameterType().equals((Object)ParameterType.RELATIVITY_SERVICE);
    }

    @JsonIgnore
    public boolean isLegalHold() {
        return this.getParameterType().equals((Object)ParameterType.LEGAL_HOLD);
    }

    @JsonIgnore
    public boolean isAzureStorageAccount() {
        return this.getParameterType().equals((Object)ParameterType.AZURE_STORAGE_ACCOUNT);
    }

    @JsonIgnore
    public boolean isFile() {
        return this.getParameterType().equals((Object)ParameterType.LIBRARY_FILE);
    }

    @JsonIgnore
    public boolean isFileContents() {
        return this.getParameterType().equals((Object)ParameterType.FILE_CONTENTS);
    }

    @JsonIgnore
    public boolean isLock() {
        return this.getParameterType().equals((Object)ParameterType.LOCK);
    }

    @JsonIgnore
    public boolean isSensitive() {
        return this.isMasked() || this.isProtected();
    }

    @JsonIgnore
    public boolean isThirdPartyServiceParameter() {
        HashSet<ParameterType> thirdPartyServiceParameters = new HashSet<ParameterType>(Arrays.asList(ParameterType.PURVIEW_SERVICE, ParameterType.RELATIVITY_SERVICE, ParameterType.DISCOVER_SERVICE, ParameterType.NLP_SERVICE, ParameterType.ECC_SERVICE, ParameterType.VAULT_SERVICE, ParameterType.GRAPH_SERVICE, ParameterType.GEN_AI_SERVICE, ParameterType.SEMANTIC_SERVICE, ParameterType.SMTP_SERVICE, ParameterType.ELASTICSEARCH_SERVICE, ParameterType.VERITONE_SERVICE));
        return thirdPartyServiceParameters.contains((Object)this.getParameterType());
    }

    public DisplayCondition getDisplayCondition() {
        if (this.displayCondition == null) {
            this.displayCondition = new DisplayCondition();
        }
        return this.displayCondition;
    }

    public void setDisplayCondition(DisplayCondition displayCondition) {
        this.displayCondition = displayCondition;
    }

    public RelativityCondition getRelativityCondition() {
        if (this.relativityCondition == null) {
            this.relativityCondition = new RelativityCondition();
        }
        return this.relativityCondition;
    }

    public void setRelativityCondition(RelativityCondition relativityCondition) {
        this.relativityCondition = relativityCondition;
    }

    public String getFriendlyName() {
        if (this.friendlyName == null) {
            StaticParameter dummyParameter = new StaticParameter(this.name, this.value);
            dummyParameter.setFriendlyNameFromName();
            return dummyParameter.getFriendlyName();
        }
        return this.friendlyName;
    }

    @JsonIgnore
    public String getFriendlyNameAndName() {
        if (this.friendlyName != null && this.friendlyName.length() == 0) {
            return this.name;
        }
        return this.getFriendlyName() + " / " + this.name;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean getMultiValue() {
        return this.multiValue;
    }

    public void setMultiValue(boolean multiValue) {
        this.multiValue = multiValue;
    }

    public String getUserDisplayableValue() {
        return this.userDisplayableValue;
    }

    public void setUserDisplayableValue(String userDisplayableValue) {
        this.userDisplayableValue = userDisplayableValue;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRegex() {
        return this.regex;
    }

    public void setRegex(String regex) {
        this.regex = regex;
    }

    public LinkedHashSet<String> getAllowedValues() {
        return this.allowedValues;
    }

    public void setAllowedValues(LinkedHashSet<String> allowedValues) {
        this.allowedValues = allowedValues;
    }

    public String getMin() {
        return this.min;
    }

    public void setMin(String min) {
        this.min = min;
    }

    public String getMax() {
        return this.max;
    }

    public void setMax(String max) {
        this.max = max;
    }

    public LinkedHashSet<String> getDependantParameters() {
        return this.dependantParameters;
    }

    public void setDependantParameters(LinkedHashSet<String> dependantParameters) {
        this.dependantParameters = dependantParameters;
    }

    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }

    public void setScriptLanguage(ScriptLanguage scriptLanguage) {
        this.scriptLanguage = scriptLanguage;
    }

    public String getScriptCode() {
        return this.scriptCode;
    }

    public void setScriptCode(String scriptCode) {
        this.scriptCode = scriptCode;
    }

    public boolean isUseLibraryFile() {
        return this.useLibraryFile;
    }

    public void setUseLibraryFile(boolean useLibraryFile) {
        this.useLibraryFile = useLibraryFile;
    }

    public String getLibraryFileId() {
        return this.libraryFileId;
    }

    public void setLibraryFileId(String libraryFileIds) {
        this.libraryFileId = libraryFileIds;
    }

    public String getDataRepositoryId() {
        return this.dataRepositoryId;
    }

    public void setDataRepositoryId(String dataRepositoryId) {
        this.dataRepositoryId = dataRepositoryId;
    }

    public Set<String> getAllowedFileExtensions() {
        return this.allowedFileExtensions;
    }

    public void setAllowedFileExtensions(Set<String> allowedFileExtensions) {
        this.allowedFileExtensions = allowedFileExtensions;
    }

    public Set<String> getAllowedDataRepositoryIds() {
        return this.allowedDataRepositoryIds;
    }

    public void setAllowedDataRepositoryIds(Set<String> allowedDataRepositoryIds) {
        this.allowedDataRepositoryIds = allowedDataRepositoryIds;
    }

    public ParameterSource getSource() {
        return this.source;
    }

    public void setSource(ParameterSource source) {
        this.source = source;
    }

    public ParameterValueMatchBy getAllowedValuesMatchBy() {
        return this.allowedValuesMatchBy;
    }

    public void setAllowedValuesMatchBy(ParameterValueMatchBy allowedValuesMatchBy) {
        this.allowedValuesMatchBy = allowedValuesMatchBy;
    }

    public void normalize() {
        if (this.parameterType == null) {
            StaticParameter dummyParameter = new StaticParameter(this.name, this.value);
            this.parameterType = dummyParameter.getEffectiveParameterType();
        }
    }
}

