/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.legalhold;

import com.nuix.automate.utils.models.api.legalhold.CustodianState;
import com.nuix.automate.utils.models.api.legalhold.LegalHoldRole;
import io.swagger.v3.oas.annotations.media.Schema;

public class LegalHoldParticipation
implements Cloneable {
    @Schema(description="Legal Hold ID", example="11111111-1111-1111-1111-111111111111")
    private String legalHoldId;
    @Schema(description="User ID", example="11111111-1111-1111-1111-111111111111")
    private String userId;
    @Schema(description="User Role")
    private LegalHoldRole role;
    @Schema(description="Custodian State")
    private CustodianState custodianState;
    @Schema(description="Hold Issued Date (Epoch)", example="1641034800000")
    private Long holdIssuedDate;
    @Schema(description="Hold Released Date (Epoch)", example="1641034800001")
    private Long holdReleasedDate;

    public LegalHoldParticipation() {
    }

    public LegalHoldParticipation(String legalHoldId, String userId, LegalHoldRole role) {
        this.legalHoldId = legalHoldId;
        this.userId = userId;
        this.role = role;
        if (LegalHoldRole.CUSTODIAN == role) {
            this.custodianState = CustodianState.DRAFT;
        }
    }

    public void copy(LegalHoldParticipation o) {
        this.legalHoldId = o.legalHoldId;
        this.userId = o.userId;
        this.role = o.role;
        this.custodianState = o.custodianState;
        this.holdIssuedDate = o.holdIssuedDate;
        this.holdReleasedDate = o.holdReleasedDate;
    }

    public LegalHoldParticipation clone() {
        try {
            return (LegalHoldParticipation)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getLegalHoldId() {
        return this.legalHoldId;
    }

    public void setLegalHoldId(String legalHoldId) {
        this.legalHoldId = legalHoldId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public LegalHoldRole getRole() {
        return this.role;
    }

    public void setRole(LegalHoldRole role) {
        this.role = role;
    }

    public CustodianState getCustodianState() {
        return this.custodianState;
    }

    public void setCustodianState(CustodianState custodianState) {
        this.custodianState = custodianState;
    }

    public Long getHoldIssuedDate() {
        return this.holdIssuedDate;
    }

    public void setHoldIssuedDate(Long holdIssuedDate) {
        this.holdIssuedDate = holdIssuedDate;
    }

    public Long getHoldReleasedDate() {
        return this.holdReleasedDate;
    }

    public void setHoldReleasedDate(Long holdReleasedDate) {
        this.holdReleasedDate = holdReleasedDate;
    }
}

