/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.legalhold;

import com.nuix.automate.utils.models.api.legalhold.JobTriggerType;
import com.nuix.automate.utils.models.api.notice.FormOption;
import com.nuix.automate.utils.models.api.notice.Notice;
import com.nuix.automate.utils.models.api.notice.NoticeConfiguration;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import java.util.Set;

public class TriggerConfiguration
implements Cloneable {
    @Schema(description="Job Configuration ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Is Job Configuration Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Workflow Library ID", example="11111111-1111-1111-1111-111111111111")
    private String workflowLibraryId;
    @Schema(description="Workflow Template ID", example="11111111-1111-1111-1111-111111111111")
    private String workflowTemplateId;
    @Schema(description="The Job Trigger")
    private JobTriggerType trigger;
    @Schema(description="Notice Template ID", example="11111111-1111-1111-1111-111111111111")
    private String noticeTemplateId;
    @Schema(description="Notice Template Version", example="11111111-1111-1111-1111-111111111111")
    private String noticeTemplateVersion;
    @Schema(description="Notice Option Key", example="11111111-1111-1111-1111-111111111111")
    private String optionKey;
    @Schema(description="Trigger Responses")
    private Set<String> triggerResponses;
    @Schema(description="Was Job Configuration Triggered?", example="true")
    private boolean triggered;

    public TriggerConfiguration clone() {
        try {
            return (TriggerConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean triggeredByNotice(Notice notice, Map<String, String> responseValues) {
        NoticeConfiguration noticeConfiguration = notice.getConfiguration();
        if (this.enabled == Boolean.TRUE && this.trigger == JobTriggerType.ON_CUSTODIAN_RESPONSE && this.triggerResponses != null && this.noticeTemplateId.equals(noticeConfiguration.getNoticeTemplateId()) && this.noticeTemplateVersion.equals(noticeConfiguration.getNoticeTemplateVersion())) {
            String value = responseValues.get(this.optionKey);
            FormOption formOption = null;
            for (FormOption option : notice.getSurveyFormOptions()) {
                if (!this.optionKey.equals(option.getKey())) continue;
                formOption = option;
                break;
            }
            if (value == null || formOption == null) {
                return false;
            }
            switch (formOption.getType()) {
                case CHECKBOX: {
                    for (String triggerResponse : this.triggerResponses) {
                        if (!triggerResponse.equalsIgnoreCase(value)) continue;
                        return true;
                    }
                    break;
                }
                default: {
                    return this.triggerResponses.contains(value);
                }
            }
        }
        return false;
    }

    public boolean isValid() {
        if (this.enabled != Boolean.TRUE) {
            return true;
        }
        if (this.workflowLibraryId != null && this.workflowTemplateId != null) {
            switch (this.trigger) {
                case ON_CUSTODIAN_RELEASE: 
                case ON_CUSTODIAN_REMINDER: 
                case ON_CUSTODIAN_ESCALATION: 
                case ON_CUSTODIAN_HOLD: 
                case ON_MATTER_ACTIVATE: 
                case ON_MATTER_ARCHIVED: 
                case ON_MATTER_RELEASE: 
                case ON_MATTER_DELETE: 
                case ON_MATTER_CUSTODIANS_HOLD: 
                case ON_MATTER_CUSTODIANS_RELEASE: {
                    return true;
                }
                case ON_CUSTODIAN_RESPONSE: {
                    return this.noticeTemplateId != null && this.noticeTemplateVersion != null && this.optionKey != null && this.triggerResponses != null && this.triggerResponses.size() > 0;
                }
            }
        }
        return false;
    }

    public boolean isChangeValid(TriggerConfiguration configuration) {
        if (this.getTriggered()) {
            return configuration != null && !this.differentSensitive(configuration);
        }
        return true;
    }

    public boolean different(TriggerConfiguration configuration) {
        if (configuration == null) {
            return true;
        }
        if (configuration.getEnabled() != null && configuration.getEnabled().equals(this.getEnabled())) {
            return true;
        }
        return this.differentSensitive(configuration);
    }

    public boolean differentSensitive(TriggerConfiguration configuration) {
        if (configuration.getWorkflowLibraryId() != null && !configuration.getWorkflowLibraryId().equals(this.getWorkflowLibraryId())) {
            return true;
        }
        if (configuration.getWorkflowTemplateId() != null && !configuration.getWorkflowTemplateId().equals(this.getWorkflowTemplateId())) {
            return true;
        }
        if (configuration.getTrigger() != null && !configuration.getTrigger().equals((Object)this.getTrigger())) {
            return true;
        }
        if (configuration.getNoticeTemplateId() != null && !configuration.getNoticeTemplateId().equals(this.getNoticeTemplateId())) {
            return true;
        }
        if (configuration.getNoticeTemplateVersion() != null && !configuration.getNoticeTemplateVersion().equals(this.getNoticeTemplateVersion())) {
            return true;
        }
        if (configuration.getOptionKey() != null && !configuration.getOptionKey().equals(this.getOptionKey())) {
            return true;
        }
        if (configuration.getTriggerResponses() != null) {
            if (this.getTriggerResponses() == null || configuration.getTriggerResponses().size() != this.getTriggerResponses().size()) {
                return true;
            }
            return !configuration.getTriggerResponses().containsAll(this.getTriggerResponses());
        }
        return false;
    }

    public void update(TriggerConfiguration configuration) {
        if (configuration.getEnabled() != null) {
            this.setEnabled(configuration.getEnabled());
        }
        if (!this.getTriggered()) {
            if (configuration.getWorkflowLibraryId() != null) {
                this.setWorkflowLibraryId(configuration.getWorkflowLibraryId());
            }
            if (configuration.getWorkflowTemplateId() != null) {
                this.setWorkflowTemplateId(configuration.getWorkflowTemplateId());
            }
            if (configuration.getTrigger() != null) {
                this.setTrigger(configuration.getTrigger());
            }
            if (configuration.getNoticeTemplateId() != null) {
                this.setNoticeTemplateId(configuration.getNoticeTemplateId());
            }
            if (configuration.getNoticeTemplateVersion() != null) {
                this.setNoticeTemplateVersion(configuration.getNoticeTemplateVersion());
            }
            if (configuration.getOptionKey() != null) {
                this.setOptionKey(configuration.getOptionKey());
            }
            if (configuration.getTriggerResponses() != null) {
                this.setTriggerResponses(configuration.getTriggerResponses());
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getWorkflowLibraryId() {
        return this.workflowLibraryId;
    }

    public void setWorkflowLibraryId(String workflowLibraryId) {
        this.workflowLibraryId = workflowLibraryId;
    }

    public String getWorkflowTemplateId() {
        return this.workflowTemplateId;
    }

    public void setWorkflowTemplateId(String workflowTemplateId) {
        this.workflowTemplateId = workflowTemplateId;
    }

    public JobTriggerType getTrigger() {
        return this.trigger;
    }

    public void setTrigger(JobTriggerType trigger) {
        this.trigger = trigger;
    }

    public String getNoticeTemplateId() {
        return this.noticeTemplateId;
    }

    public void setNoticeTemplateId(String noticeTemplateId) {
        this.noticeTemplateId = noticeTemplateId;
    }

    public String getNoticeTemplateVersion() {
        return this.noticeTemplateVersion;
    }

    public void setNoticeTemplateVersion(String noticeTemplateVersion) {
        this.noticeTemplateVersion = noticeTemplateVersion;
    }

    public String getOptionKey() {
        return this.optionKey;
    }

    public void setOptionKey(String optionKey) {
        this.optionKey = optionKey;
    }

    public Set<String> getTriggerResponses() {
        return this.triggerResponses;
    }

    public void setTriggerResponses(Set<String> triggerResponses) {
        this.triggerResponses = triggerResponses;
    }

    public boolean getTriggered() {
        return this.triggered;
    }

    public void setTriggered(boolean triggered) {
        this.triggered = triggered;
    }
}

