/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notice;

import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.models.api.notice.CommentType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Set;

public class NoticeComment
extends UserPermissionModel {
    @Schema(description="Notice Commend ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Notice Event ID", example="11111111-1111-1111-1111-111111111111")
    private String noticeEventId;
    @Schema(description="Parent Comment ID", example="11111111-1111-1111-1111-111111111111")
    private String parentCommentId;
    @Schema(description="User ID", example="11111111-1111-1111-1111-111111111111")
    private String userId;
    @Schema(description="Username", example="John@email.com")
    private String username;
    @Schema(description="Notice Comment Type")
    private CommentType type;
    @Schema(description="Message", example="This is a sample comment")
    private String message;
    @Schema(description="Notice Comment Created Date (Epoch)", example="1641034800000")
    private Long createdDate;

    @Override
    public NoticeComment clone() {
        return (NoticeComment)super.clone();
    }

    public boolean canView() {
        Set<Permission> userPermissions = this.getUserPermissions();
        if (userPermissions != null) {
            switch (this.type) {
                case ADMIN_NOTE: {
                    return userPermissions.contains((Object)Permission.VIEW) || userPermissions.contains((Object)Permission.MANAGE);
                }
            }
            return userPermissions.contains((Object)Permission.VIEW) || userPermissions.contains((Object)Permission.MANAGE) || userPermissions.contains((Object)Permission.RESPOND) || userPermissions.contains((Object)Permission.MODIFY);
        }
        return false;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getNoticeEventId() {
        return this.noticeEventId;
    }

    public void setNoticeEventId(String noticeEventId) {
        this.noticeEventId = noticeEventId;
    }

    public String getParentCommentId() {
        return this.parentCommentId;
    }

    public void setParentCommentId(String parentCommentId) {
        this.parentCommentId = parentCommentId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public CommentType getType() {
        return this.type;
    }

    public void setType(CommentType type) {
        this.type = type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }
}

