/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notice;

import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.notice.Notice;
import com.nuix.automate.utils.models.api.notice.NoticeEvent;
import com.nuix.automate.utils.models.api.notice.NoticeType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.Map;

public class NoticeInfo {
    @Schema(description="Notice Info ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Notice Subject", example="This is a subject")
    private String subject;
    @Schema(description="Notice Type")
    private NoticeType type;
    @Schema(description="Is Notice Info Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Notice Info Created Date (Epoch)", example="1641034800000")
    private Long createdDate;
    @Schema(description="Notice Info Events Count", example="3")
    private int eventsCount;
    @Schema(description="Notice Info Viewed Events Count", example="3")
    private int viewedCount;
    @Schema(description="Notice Info Responded Events Count", example="3")
    private int respondedCount;
    @Schema(description="Notice Info Escalated Events Count", example="3")
    private int escalatedCount;

    public NoticeInfo(Notice noticeModel, List<NoticeEvent> noticeEvents) {
        this.id = noticeModel.getId();
        this.subject = noticeModel.getSubject();
        this.type = noticeModel.getType();
        this.enabled = noticeModel.getEnabled();
        this.createdDate = noticeModel.getCreatedDate();
        this.eventsCount = noticeEvents.size();
        for (NoticeEvent noticeEvent : noticeEvents) {
            if (noticeEvent.getLastViewedDate() != null) {
                ++this.viewedCount;
            }
            if (noticeEvent.getLastRespondedDate() != null) {
                ++this.respondedCount;
            }
            if (noticeEvent.getEscalatedDate() == null) continue;
            ++this.escalatedCount;
        }
    }

    public void evaluateParameters(Map<String, Parameter> parameters) {
        for (String parameterName : parameters.keySet()) {
            String parameterValue = parameters.get(parameterName).getValue();
            this.subject = this.subject.replace(parameterName, parameterValue);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public NoticeType getType() {
        return this.type;
    }

    public void setType(NoticeType type) {
        this.type = type;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public int getEventsCount() {
        return this.eventsCount;
    }

    public void setEventsCount(int eventsCount) {
        this.eventsCount = eventsCount;
    }

    public int getViewedCount() {
        return this.viewedCount;
    }

    public void setViewedCount(int viewedCount) {
        this.viewedCount = viewedCount;
    }

    public int getRespondedCount() {
        return this.respondedCount;
    }

    public void setRespondedCount(int respondedCount) {
        this.respondedCount = respondedCount;
    }

    public int getEscalatedCount() {
        return this.escalatedCount;
    }

    public void setEscalatedCount(int escalatedCount) {
        this.escalatedCount = escalatedCount;
    }
}

