/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notice;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.notice.FormOption;
import com.nuix.automate.utils.models.api.notice.NoticeType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NoticeTemplateSubmission
implements Serializable,
Cloneable {
    @Schema(description="Notice Type")
    private NoticeType type;
    @Schema(description="Is Notice Template Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Notice Template Name", example="Default Hold Notice")
    private String name;
    @Schema(description="Notice Template Description", example="This is a sample description")
    private String description;
    @Schema(description="Notice Template Subject", example="Project X Legal Hold Notice")
    private String subject;
    @Schema(description="Notice Template Message (Markdown)", example="Sample notice template message")
    private String message;
    @Schema(description="Notice Parameters")
    private Map<String, Parameter> parameters;
    @Schema(description="Notice Survey Form Options")
    private List<FormOption> surveyFormOptions;

    public void normalizeParameters() {
        HashMap<String, Parameter> normalizedParameters = new HashMap<String, Parameter>();
        if (this.parameters != null) {
            for (String paramName : this.parameters.keySet()) {
                String normalizedParameterName = FormattingUtils.normalizeParameterName(paramName);
                Parameter parameterModel = this.parameters.get(paramName);
                parameterModel.setName(normalizedParameterName);
                normalizedParameters.put(normalizedParameterName, parameterModel);
            }
        }
        this.setParameters(normalizedParameters);
    }

    public NoticeType getType() {
        return this.type;
    }

    public void setType(NoticeType type) {
        this.type = type;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Map<String, Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Parameter> parameters) {
        this.parameters = parameters;
    }

    public List<FormOption> getSurveyFormOptions() {
        return this.surveyFormOptions;
    }

    public void setSurveyFormOptions(List<FormOption> surveyFormOptions) {
        this.surveyFormOptions = surveyFormOptions;
    }
}

