/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notice;

import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.notice.FormElementType;
import com.nuix.automate.utils.models.api.notice.FormOption;
import com.nuix.automate.utils.models.api.notice.Notice;
import com.nuix.automate.utils.models.api.notice.NoticeEvent;
import com.nuix.automate.utils.models.api.notice.NoticeType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UserNotice
extends UserPermissionModel {
    @Schema(description="User Notice ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Notice Event Parent ID", example="11111111-1111-1111-1111-111111111111")
    private String parentId;
    @Schema(description="Legal Hold ID", example="11111111-1111-1111-1111-111111111111")
    private String legalHoldId;
    @Schema(description="Notice Template ID", example="11111111-1111-1111-1111-111111111111")
    private String noticeId;
    @Schema(description="User ID", example="11111111-1111-1111-1111-111111111111")
    private String userId;
    @Schema(description="Is User Notice Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Is Template Notice Enabled?", example="true")
    private Boolean noticeEnabled;
    @Schema(description="Are User Notice Comments Disabled?", example="true")
    private Boolean disableComments;
    @Schema(description="Are User Notice Admin Notes Disabled?", example="true")
    private Boolean disableAdminNotes;
    @Schema(description="Are Notice Template Comments Disabled?", example="true")
    private Boolean noticeDisableComments;
    @Schema(description="User Notice Type")
    private NoticeType type;
    @Schema(description="User Notice Subject", example="Sample Notice")
    private String subject;
    @Schema(description="User Notice Message", example="This is a sample notice")
    private String message;
    @Schema(description="User Notice Survey Form Options")
    private List<FormOption> surveyFormOptions;
    @Schema(description="User Notice Created Date (Epoch)", example="1641034800000")
    private Long createdDate;
    @Schema(description="User Notice Reissued Date (Epoch)", example="1641034800000")
    private Long sentDate;
    @Schema(description="User Notice Last Viewed Date (Epoch)", example="1641034800000")
    private Long lastViewedDate;
    @Schema(description="User Notice Last Responded Date (Epoch)", example="1641034800000")
    private Long lastRespondedDate;
    @Schema(description="User Notice Responded Date (Epoch)", example="1641034800000")
    private Long respondedDate;
    @Schema(description="User Notice Escalated Date (Epoch)", example="1641034800000")
    private Long escalatedDate;
    @Schema(description="User Notice Respond By Date (Epoch)", example="1641034800000")
    private Long respondByDate;
    @Schema(description="User Notice Last Reminded Date (Epoch)", example="1641034800000")
    private Long lastRemindedDate;
    @Schema(description="User Notice Last Comment Date (Epoch)", example="1641034800000")
    private Long lastCommentedDate;
    @Schema(description="Notice Event Last Comment User ID", example="11111111-1111-1111-1111-111111111111")
    private String lastCommentedUserId;
    @Schema(description="User Notice Last Admin Note Date (Epoch)", example="1641034800000")
    private Long lastAdminNoteDate;
    @Schema(description="Notice Event Last Admin Note User ID", example="11111111-1111-1111-1111-111111111111")
    private String lastAdminNoteUserId;
    @Schema(description="User Notice Last Admins View Date")
    private Map<String, Long> adminLastViewedDate;
    @Schema(description="Is User Notice Outstanding?", example="true")
    private Boolean outstanding;

    public UserNotice() {
    }

    public UserNotice(Notice noticeModel, NoticeEvent noticeEvent) {
        this.legalHoldId = noticeModel.getLegalHoldId();
        this.noticeId = noticeModel.getId();
        this.type = noticeModel.getType();
        this.subject = noticeModel.getSubject();
        this.message = noticeModel.getMessage();
        this.surveyFormOptions = new ArrayList<FormOption>();
        this.id = noticeEvent.getId();
        this.parentId = noticeEvent.getParentId();
        this.userId = noticeEvent.getUserId();
        this.createdDate = noticeEvent.getCreatedDate();
        this.sentDate = noticeEvent.getSentDate();
        this.lastViewedDate = noticeEvent.getLastViewedDate();
        this.lastRespondedDate = noticeEvent.getLastRespondedDate();
        this.respondedDate = noticeEvent.getRespondedDate();
        this.escalatedDate = noticeEvent.getEscalatedDate();
        if (noticeModel.getConfiguration().getRequireResponse() == Boolean.TRUE) {
            this.respondByDate = noticeModel.getConfiguration().getRespondByMillis(this.sentDate);
        }
        this.lastRemindedDate = noticeEvent.getLastRemindedDate();
        this.lastCommentedDate = noticeEvent.getLastCommentedDate();
        this.lastCommentedUserId = noticeEvent.getLastCommentedUserId();
        this.lastAdminNoteDate = noticeEvent.getLastAdminNoteDate();
        this.lastAdminNoteUserId = noticeEvent.getLastAdminNoteUserId();
        this.enabled = noticeEvent.getEnabled() == Boolean.TRUE;
        this.noticeEnabled = noticeModel.getEnabled() == Boolean.TRUE;
        this.disableComments = noticeEvent.getDisableComments() == Boolean.TRUE;
        this.disableAdminNotes = noticeModel.getConfiguration().getDisableAdminNotes() == Boolean.TRUE;
        this.noticeDisableComments = noticeModel.getConfiguration().getDisableComments() == Boolean.TRUE;
    }

    public void setSurveyFormOptions(Notice noticeModel, NoticeEvent noticeEvent) {
        boolean showValues = this.getUserPermissions() != null && (this.getUserPermissions().contains((Object)Permission.VIEW_SENSITIVE) || this.getUserPermissions().contains((Object)Permission.RESPOND) || this.getUserPermissions().contains((Object)Permission.MANAGE));
        Map<String, String> surveyFormValues = noticeEvent.getSurveyFormValues();
        for (FormOption formOption : noticeModel.getSurveyFormOptions()) {
            String key = formOption.getKey();
            FormOption valueUpdatedOption = new FormOption(formOption);
            if (showValues && surveyFormValues != null && surveyFormValues.get(key) != null) {
                String value = surveyFormValues.get(key);
                valueUpdatedOption.setValue(value);
            }
            this.surveyFormOptions.add(valueUpdatedOption);
        }
    }

    public void evaluateParameters(Map<String, Parameter> parameters) {
        for (String parameterName : parameters.keySet()) {
            String parameterValue = parameters.get(parameterName).getValue();
            this.subject = this.subject.replace(parameterName, parameterValue);
            this.message = this.message.replace(parameterName, parameterValue);
            if (this.surveyFormOptions == null) continue;
            for (FormOption formOption : this.surveyFormOptions) {
                if (formOption.getTitle() != null) {
                    formOption.setTitle(formOption.getTitle().replace(parameterName, parameterValue));
                }
                if (formOption.getDescription() != null) {
                    formOption.setDescription(formOption.getDescription().replace(parameterName, parameterValue));
                }
                if (formOption.getLabel() != null) {
                    formOption.setLabel(formOption.getLabel().replace(parameterName, parameterValue));
                }
                if (!FormElementType.DROPDOWN.equals((Object)formOption.getType()) || formOption.getAllowedValues() == null) continue;
                LinkedHashSet<String> allowedValues = new LinkedHashSet<String>();
                for (String allowedValue : formOption.getAllowedValues()) {
                    allowedValues.add(allowedValue.replace(parameterName, parameterValue));
                }
                formOption.setAllowedValues(allowedValues);
            }
        }
    }

    public void evaluateOutstanding(String viewingAdminId) {
        boolean outstanding = false;
        Set<Permission> userPermissions = this.getUserPermissions();
        if (userPermissions != null && this.noticeEnabled.booleanValue() && this.enabled.booleanValue()) {
            if (userPermissions.contains((Object)Permission.RESPOND)) {
                outstanding = this.lastViewedDate == null || this.surveyFormOptions != null && this.surveyFormOptions.size() > 0 && this.lastRespondedDate == null;
            } else if (userPermissions.contains((Object)Permission.MANAGE)) {
                boolean bl = outstanding = this.lastRespondedDate == null && this.lastCommentedDate != null && this.userId.equals(this.lastCommentedUserId);
                if (!outstanding && this.lastAdminNoteDate != null && !viewingAdminId.equals(this.lastAdminNoteUserId)) {
                    Long adminLastViewed = this.adminLastViewedDate.get(viewingAdminId);
                    outstanding = adminLastViewed == null || adminLastViewed <= this.lastAdminNoteDate;
                }
            }
        }
        this.setOutstanding(outstanding);
    }

    public boolean canView() {
        Set<Permission> userPermissions = this.getUserPermissions();
        if (userPermissions != null) {
            return userPermissions.contains((Object)Permission.VIEW) || userPermissions.contains((Object)Permission.MANAGE) || userPermissions.contains((Object)Permission.RESPOND);
        }
        return false;
    }

    @Override
    public UserNotice clone() {
        return (UserNotice)super.clone();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getLegalHoldId() {
        return this.legalHoldId;
    }

    public void setLegalHoldId(String legalHoldId) {
        this.legalHoldId = legalHoldId;
    }

    public String getNoticeId() {
        return this.noticeId;
    }

    public void setNoticeId(String noticeId) {
        this.noticeId = noticeId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getNoticeEnabled() {
        return this.noticeEnabled;
    }

    public void setNoticeEnabled(Boolean noticeEnabled) {
        this.noticeEnabled = noticeEnabled;
    }

    public Boolean getDisableComments() {
        return this.disableComments;
    }

    public void setDisableComments(Boolean disableComments) {
        this.disableComments = disableComments;
    }

    public Boolean getDisableAdminNotes() {
        return this.disableAdminNotes;
    }

    public void setDisableAdminNotes(Boolean disableAdminNotes) {
        this.disableAdminNotes = disableAdminNotes;
    }

    public Boolean getNoticeDisableComments() {
        return this.noticeDisableComments;
    }

    public void setNoticeDisableComments(Boolean noticeDisableComments) {
        this.noticeDisableComments = noticeDisableComments;
    }

    public NoticeType getType() {
        return this.type;
    }

    public void setType(NoticeType type) {
        this.type = type;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public List<FormOption> getSurveyFormOptions() {
        return this.surveyFormOptions;
    }

    public void setSurveyFormOptions(List<FormOption> surveyFormOptions) {
        this.surveyFormOptions = surveyFormOptions;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public Long getSentDate() {
        return this.sentDate;
    }

    public void setSentDate(Long sentDate) {
        this.sentDate = sentDate;
    }

    public Long getLastViewedDate() {
        return this.lastViewedDate;
    }

    public void setLastViewedDate(Long lastViewedDate) {
        this.lastViewedDate = lastViewedDate;
    }

    public Long getLastRespondedDate() {
        return this.lastRespondedDate;
    }

    public void setLastRespondedDate(Long lastRespondedDate) {
        this.lastRespondedDate = lastRespondedDate;
    }

    public Long getRespondedDate() {
        return this.respondedDate;
    }

    public void setRespondedDate(Long respondedDate) {
        this.respondedDate = respondedDate;
    }

    public Long getEscalatedDate() {
        return this.escalatedDate;
    }

    public void setEscalatedDate(Long escalatedDate) {
        this.escalatedDate = escalatedDate;
    }

    public Long getRespondByDate() {
        return this.respondByDate;
    }

    public void setRespondByDate(Long respondByDate) {
        this.respondByDate = respondByDate;
    }

    public Long getLastRemindedDate() {
        return this.lastRemindedDate;
    }

    public void setLastRemindedDate(Long lastRemindedDate) {
        this.lastRemindedDate = lastRemindedDate;
    }

    public Long getLastCommentedDate() {
        return this.lastCommentedDate;
    }

    public void setLastCommentedDate(Long lastCommentedDate) {
        this.lastCommentedDate = lastCommentedDate;
    }

    public String getLastCommentedUserId() {
        return this.lastCommentedUserId;
    }

    public void setLastCommentedUserId(String lastCommentedUserId) {
        this.lastCommentedUserId = lastCommentedUserId;
    }

    public Long getLastAdminNoteDate() {
        return this.lastAdminNoteDate;
    }

    public void setLastAdminNoteDate(Long lastAdminNoteDate) {
        this.lastAdminNoteDate = lastAdminNoteDate;
    }

    public String getLastAdminNoteUserId() {
        return this.lastAdminNoteUserId;
    }

    public void setLastAdminNoteUserId(String lastAdminNoteUserId) {
        this.lastAdminNoteUserId = lastAdminNoteUserId;
    }

    public Map<String, Long> getAdminLastViewedDate() {
        return this.adminLastViewedDate;
    }

    public void setAdminLastViewedDate(Map<String, Long> adminLastViewedDate) {
        this.adminLastViewedDate = adminLastViewedDate;
    }

    public Boolean getOutstanding() {
        return this.outstanding;
    }

    public void setOutstanding(Boolean outstanding) {
        this.outstanding = outstanding;
    }
}

