/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.notificationrule;

import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.notificationrule.NotificationRule;
import com.nuix.automate.utils.models.api.smtp.SmtpEmailCounter;
import io.swagger.v3.oas.annotations.media.Schema;

public class EmailNotificationRule
extends NotificationRule {
    @Schema(description="SMTP Service ID", example="11111111-1111-1111-1111-111111111111")
    private String smtpServiceId;
    @Schema(description="Email To", example="jsmith@example.com")
    private String to;
    @Schema(description="Email CC", example="jsmith@example.com")
    private String cc;
    @Schema(description="Is the Message in HTML Format?", example="true")
    private Boolean htmlFormat;
    private SmtpEmailCounter emailCounter;

    public String toString() {
        try {
            return "emailNotificationRule " + this.getName() + " (" + FormattingUtils.getShortId(this.getId(), 8) + ")";
        }
        catch (Exception e) {
            return "emailNotificationRule " + this.getName() + " (N/A)";
        }
    }

    public String getSmtpServiceId() {
        return this.smtpServiceId;
    }

    public String getTo() {
        return this.to;
    }

    public String getCc() {
        return this.cc;
    }

    public Boolean getHtmlFormat() {
        return this.htmlFormat;
    }

    public SmtpEmailCounter getEmailCounter() {
        return this.emailCounter;
    }

    public void setSmtpServiceId(String smtpServiceId) {
        this.smtpServiceId = smtpServiceId;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public void setHtmlFormat(Boolean htmlFormat) {
        this.htmlFormat = htmlFormat;
    }

    public void setEmailCounter(SmtpEmailCounter emailCounter) {
        this.emailCounter = emailCounter;
    }
}

