/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.nuixlicensesource;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.models.api.nuixlicensesource.RelayType;
import com.nuix.automate.utils.models.api.nuixlicensesource.SourceType;
import com.nuix.automate.utils.models.internal.nuixlicensesource.NuixLicenseSourceModel;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Set;
import java.util.TreeSet;

public class NuixLicenseSource
extends UserPermissionModel
implements Serializable,
Cloneable {
    @Schema(description="Nuix License Source ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Nuix License Source Name", example="Default License")
    private String name;
    @Schema(description="Nuix License Source Description", example="The default license source")
    private String description;
    @Schema(description="Nuix License Source Type")
    private SourceType sourceType;
    @Schema(description="Nuix License Relay Type")
    private RelayType relayType;
    @Schema(description="Nuix License Source Server Name", example="nms.example.com")
    private String serverName;
    @Schema(description="Nuix License Source Server Port", example="27443")
    private Integer serverPort;
    @Schema(description="Nuix License Source Username", example="jsmith@example.com")
    private String username;
    @Schema(description="Nuix License Source Filter", example="workstation")
    private String filter;
    @Schema(description="Nuix License Source Whitelisted Certificates Fingerprints (SHA-512)", example="[\"e62dd01ca608c10402d07714cfd626bfc6b1001e5a16ca039d1050a71f73ee24\",\"d5129635a050f63dd607ffa9271eefaab597c0975809765dad253973fc554d25\"]")
    private Set<String> whitelistedCertFingerprints;
    @Schema(description="Nuix License Source Status")
    private Status status;

    public NuixLicenseSource() {
    }

    @Override
    public NuixLicenseSource clone() {
        NuixLicenseSource clonedObject = (NuixLicenseSource)super.clone();
        clonedObject.whitelistedCertFingerprints = new TreeSet<String>();
        if (this.whitelistedCertFingerprints != null) {
            clonedObject.whitelistedCertFingerprints.addAll(this.whitelistedCertFingerprints);
        }
        return clonedObject;
    }

    public NuixLicenseSource(NuixLicenseSourceModel n) {
        this.id = n.getId();
        this.name = n.getName();
        this.description = n.getDescription();
        this.sourceType = n.getSourceType();
        this.relayType = n.getRelayType();
        this.serverName = n.getServerName();
        this.serverPort = n.getServerPort();
        this.username = n.getUsername();
        this.filter = n.getFilter();
        this.whitelistedCertFingerprints = n.getWhitelistedCertFingerprints();
        this.status = n.getStatus();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public RelayType getRelayType() {
        return this.relayType;
    }

    public void setRelayType(RelayType relayType) {
        this.relayType = relayType;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(Integer serverPort) {
        this.serverPort = serverPort;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public Set<String> getWhitelistedCertFingerprints() {
        return this.whitelistedCertFingerprints;
    }

    public void setWhitelistedCertFingerprints(Set<String> fingerprints) {
        this.whitelistedCertFingerprints = fingerprints;
    }

    public Status getStatus() {
        if (this.status == null) {
            this.status = new Status();
        }
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public NuixLicenseSource cloneLimited() {
        NuixLicenseSource limited = new NuixLicenseSource();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.setUserPermissions(this.cloneUserPermissions());
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        limited.sourceType = this.sourceType;
        return limited;
    }
}

