/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.resourcepool;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public class AwsResourcePoolSettingsSubmission
implements Serializable {
    @Schema(description="Access Key", example="11111111-1111-1111-1111-111111111111")
    private String accessKey;
    @Schema(description="Secret Key", example="I7zG7gm1O8EGIbv8bpRA2qYZkJsCBUMM")
    private String secretKey;
    @Schema(description="AWS Region")
    private String region;
    @Schema(description="AWS Instance IDs", example="[\"i-111111111\",\"i-222222222\"]")
    private Set<String> instanceIds;
    @Schema(description="AWS Launch Template IDs", example="[\"lt-111111111\",\"lt-222222222\"]")
    private String launchTemplateId;
    @Schema(description="Max Concurrent Instances", example="4")
    private Integer maxConcurrentInstances;
    @Schema(description="AWS Tag Name", example="instance-type")
    private String tagName;
    @Schema(description="AWS Tag Value", example="automate")
    private String tagValue;

    public String getLaunchTemplateId() {
        return this.launchTemplateId;
    }

    public AwsResourcePoolSettingsSubmission() {
    }

    public AwsResourcePoolSettingsSubmission(AwsResourcePoolSettingsSubmission copy) {
        this.maxConcurrentInstances = copy.maxConcurrentInstances;
        this.accessKey = copy.accessKey;
        this.secretKey = copy.secretKey;
        this.region = copy.region;
        this.launchTemplateId = copy.launchTemplateId;
        this.instanceIds = new HashSet<String>();
        if (copy.instanceIds != null) {
            this.instanceIds.addAll(copy.instanceIds);
        }
        this.tagName = copy.tagName;
        this.tagValue = copy.tagValue;
    }

    public void setLaunchTemplateId(String launchTemplateId) {
        this.launchTemplateId = launchTemplateId;
    }

    public Integer getMaxConcurrentInstances() {
        return this.maxConcurrentInstances;
    }

    public void setMaxConcurrentInstances(Integer maxConcurrentInstances) {
        this.maxConcurrentInstances = maxConcurrentInstances;
    }

    public void removeSecrets() {
        this.secretKey = null;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Set<String> getInstanceIds() {
        return this.instanceIds;
    }

    public void setInstanceIds(Set<String> instanceIds) {
        this.instanceIds = instanceIds;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String tagName) {
        this.tagName = tagName;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public void setTagValue(String tagValue) {
        this.tagValue = tagValue;
    }
}

