/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.schedule;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.UidUtils;
import com.nuix.automate.utils.models.api.job.Parameter;
import com.nuix.automate.utils.models.api.job.Priority;
import com.nuix.automate.utils.models.api.schedule.Conditions;
import com.nuix.automate.utils.models.api.schedule.EventTrigger;
import com.nuix.automate.utils.models.api.schedule.RecurrentTrigger;
import com.nuix.automate.utils.models.api.schedule.WebhookTrigger;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Schedule
extends UserPermissionModel
implements Serializable,
Cloneable {
    public static final String SAME_AS_TRIGGERING_DATASET = "SAME_AS_TRIGGERING_DATASET";
    @Schema(description="Schedule ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Schedule Name", example="Archive Cases Weekly")
    private String name;
    @Schema(description="Schedule Description", example="Run a weekly job to archive cases")
    private String description;
    @Schema(description="Is Schedule Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Schedule Referece", example="Internal Ref 1")
    private String reference;
    @Schema(description="Schedule Created By", example="jsmith@example.com")
    private String createdBy;
    @Schema(description="Schedule Created Date (Epoch)", example="1641034800000")
    private Long createdDate;
    @Schema(description="Schedule User Identifier")
    private String lastModifiedByUserId;
    @Schema(description="Schedule Last Modified By", example="jsmith@example.com")
    private String lastModifiedBy;
    @Schema(description="Schedule Last Modified Date (Epoch)", example="1641034800000")
    private Long lastModifiedDate;
    @Schema(description="Schedule Event Trigger")
    private EventTrigger eventTrigger;
    @Schema(description="Schedule Recurrent Trigger")
    private RecurrentTrigger scheduleTrigger;
    @Schema(description="Schedule Webhook Trigger")
    private WebhookTrigger webhookTrigger;
    @Schema(description="Schedule Conditions")
    private Conditions conditions;
    @Schema(description="Is Scheduled Job Same As Triggering Job?", example="true")
    private Boolean sameMatterAsTriggerMatter;
    @Schema(description="Scheduled Job Matter ID", example="11111111-1111-1111-1111-111111111111")
    private String matterId;
    @Schema(description="Scheduled Job Client ID", example="11111111-1111-1111-1111-111111111111")
    private String clientId;
    @Schema(description="Is Execution Profile Same As Triggering Job?", example="true")
    private Boolean sameExecutionProfileAsTriggerMatter;
    @Schema(description="Scheduled Execution Profile ID", example="11111111-1111-1111-1111-111111111111")
    private String executionProfileId;
    @Schema(description="Is Resource Pool Same As Triggering Job?", example="true")
    private Boolean sameResourcePoolIdAsTriggerMatter;
    @Schema(description="Scheduled Resource Pool ID", example="11111111-1111-1111-1111-111111111111")
    private String resourcePoolId;
    @Schema(description="Is Priority Same As Triggering Job?", example="true")
    private Boolean samePriorityAsTriggerMatter;
    @Schema(description="Scheduled Priority")
    private Priority priority;
    @Schema(description="Is Workflow Same As Triggering Job?", example="true")
    private Boolean sameWorkflowTemplateAsTriggerMatter;
    @Schema(description="Scheduled Workflow ID", example="11111111-1111-1111-1111-111111111111")
    private String libraryWorkflowId;
    @Schema(description="Scheduled Workflow Library ID", example="11111111-1111-1111-1111-111111111111")
    private String libraryId;
    @Schema(description="Scheduled Job Parameters")
    private List<Parameter> sessionParameters;
    @Schema(description="Schedule Status")
    private Status status;

    @Override
    public Schedule clone() {
        Schedule clonedObject = (Schedule)super.clone();
        if (this.webhookTrigger != null) {
            clonedObject.setWebhookTrigger(this.webhookTrigger.clone());
        }
        if (this.sessionParameters != null) {
            clonedObject.sessionParameters = new ArrayList<Parameter>();
            for (Parameter parameterModel : this.sessionParameters) {
                clonedObject.sessionParameters.add(parameterModel.clone());
            }
        }
        return clonedObject;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Long createdDate) {
        this.createdDate = createdDate;
    }

    public Conditions getConditions() {
        return this.conditions;
    }

    public void setConditions(Conditions conditions) {
        this.conditions = conditions;
    }

    public EventTrigger getEventTrigger() {
        return this.eventTrigger;
    }

    public void setEventTrigger(EventTrigger eventTrigger) {
        this.eventTrigger = eventTrigger;
    }

    public RecurrentTrigger getScheduleTrigger() {
        return this.scheduleTrigger;
    }

    public void setScheduleTrigger(RecurrentTrigger recurrentTrigger) {
        this.scheduleTrigger = recurrentTrigger;
    }

    public WebhookTrigger getWebhookTrigger() {
        return this.webhookTrigger;
    }

    public void setWebhookTrigger(WebhookTrigger webhookTrigger) {
        this.webhookTrigger = webhookTrigger;
    }

    public Boolean getSameMatterAsTriggerMatter() {
        return this.sameMatterAsTriggerMatter;
    }

    public void setSameMatterAsTriggerMatter(Boolean sameMatterAsTriggerMatter) {
        this.sameMatterAsTriggerMatter = sameMatterAsTriggerMatter;
    }

    public String getMatterId() {
        return this.matterId;
    }

    public void setMatterId(String matterId) {
        this.matterId = matterId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public Boolean getSameExecutionProfileAsTriggerMatter() {
        return this.sameExecutionProfileAsTriggerMatter;
    }

    public void setSameExecutionProfileAsTriggerMatter(Boolean sameExecutionProfileAsTriggerMatter) {
        this.sameExecutionProfileAsTriggerMatter = sameExecutionProfileAsTriggerMatter;
    }

    public String getExecutionProfileId() {
        return this.executionProfileId;
    }

    public void setExecutionProfileId(String executionProfileId) {
        this.executionProfileId = executionProfileId;
    }

    public Boolean getSameResourcePoolIdAsTriggerMatter() {
        return this.sameResourcePoolIdAsTriggerMatter;
    }

    public void setSameResourcePoolIdAsTriggerMatter(Boolean sameResourcePoolIdAsTriggerMatter) {
        this.sameResourcePoolIdAsTriggerMatter = sameResourcePoolIdAsTriggerMatter;
    }

    public String getResourcePoolId() {
        return this.resourcePoolId;
    }

    public void setResourcePoolId(String resourcePoolId) {
        this.resourcePoolId = resourcePoolId;
    }

    public Boolean getSamePriorityAsTriggerMatter() {
        return this.samePriorityAsTriggerMatter;
    }

    public void setSamePriorityAsTriggerMatter(Boolean samePriorityAsTriggerMatter) {
        this.samePriorityAsTriggerMatter = samePriorityAsTriggerMatter;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public Boolean getSameWorkflowTemplateAsTriggerMatter() {
        return this.sameWorkflowTemplateAsTriggerMatter;
    }

    public void setSameWorkflowTemplateAsTriggerMatter(Boolean sameWorkflowTemplateAsTriggerMatter) {
        this.sameWorkflowTemplateAsTriggerMatter = sameWorkflowTemplateAsTriggerMatter;
    }

    public String getLibraryWorkflowId() {
        return this.libraryWorkflowId;
    }

    public void setLibraryWorkflowId(String libraryWorkflowId) {
        this.libraryWorkflowId = libraryWorkflowId;
    }

    public String getLibraryId() {
        return this.libraryId;
    }

    public void setLibraryId(String libraryId) {
        this.libraryId = libraryId;
    }

    public List<Parameter> getSessionParameters() {
        return this.sessionParameters;
    }

    public List<Parameter> getNonNullSessionParameters() {
        if (this.sessionParameters == null) {
            return new ArrayList<Parameter>();
        }
        return this.sessionParameters;
    }

    public void setSessionParameters(List<Parameter> sessionParameters) {
        this.sessionParameters = sessionParameters;
    }

    public String getLastModifiedByUserId() {
        return this.lastModifiedByUserId;
    }

    public void setLastModifiedByUserId(String lastModifiedByUserId) {
        this.lastModifiedByUserId = lastModifiedByUserId;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String toString() {
        try {
            return "schedule " + this.getName() + " (" + UidUtils.getShortId(this.id) + ")";
        }
        catch (Exception e) {
            return "schedule " + this.getName() + " (N/A)";
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Schedule " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (this.getConditions() == null) {
            this.setConditions(new Conditions());
        }
        if (this.getEnabled() == null) {
            this.setEnabled(false);
        }
        if (this.getSessionParameters() == null) {
            this.setSessionParameters(new ArrayList<Parameter>());
        }
        for (Parameter parameter : this.getNonNullSessionParameters()) {
            if (parameter.getDescription() == null) {
                parameter.setDescription("");
            }
            if (parameter.getFriendlyName() != null) continue;
            parameter.setFriendlyName("");
        }
    }

    public Schedule cloneLimited() {
        Schedule limited = new Schedule();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.enabled = this.enabled;
        limited.clientId = this.clientId;
        limited.matterId = this.matterId;
        limited.libraryWorkflowId = this.libraryWorkflowId;
        limited.libraryId = this.libraryId;
        limited.setUserPermissions(this.cloneUserPermissions());
        if (this.status != null) {
            limited.setStatus(this.status.cloneLimited());
        }
        limited.executionProfileId = this.executionProfileId;
        limited.resourcePoolId = this.resourcePoolId;
        limited.priority = this.priority;
        limited.eventTrigger = this.eventTrigger;
        limited.scheduleTrigger = this.scheduleTrigger;
        limited.webhookTrigger = this.webhookTrigger;
        limited.sameMatterAsTriggerMatter = this.sameMatterAsTriggerMatter;
        limited.sameExecutionProfileAsTriggerMatter = this.sameExecutionProfileAsTriggerMatter;
        limited.samePriorityAsTriggerMatter = this.samePriorityAsTriggerMatter;
        limited.sameResourcePoolIdAsTriggerMatter = this.sameResourcePoolIdAsTriggerMatter;
        return limited;
    }
}

