/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.securitypolicy;

import com.nuix.automate.utils.security.policies.BuiltInPrincipalIdentifiers;
import com.nuix.automate.utils.security.policies.BuiltInScopeIdentifiers;
import com.nuix.automate.utils.security.policies.IdentifierType;
import io.swagger.v3.oas.annotations.media.Schema;
import org.jetbrains.annotations.NotNull;

public class Identifier
implements Comparable<Identifier>,
Cloneable {
    @Schema(description="Identifier Type")
    private IdentifierType identifierType;
    @Schema(description="Identifier Name", example="user@example.com")
    private String identifierName;
    private transient String cachedPrintableName;
    private transient Integer cachedHashCode;

    public Identifier() {
    }

    public Identifier(IdentifierType identifierType, String name) {
        this.identifierType = identifierType;
        this.identifierName = name;
    }

    public Identifier(IdentifierType identifierType, Enum e) {
        this.identifierType = identifierType;
        this.identifierName = e.name();
    }

    public Identifier clone() {
        return new Identifier(this.identifierType, this.identifierName);
    }

    public IdentifierType getIdentifierType() {
        return this.identifierType;
    }

    public void setIdentifierType(IdentifierType identifierType) {
        this.identifierType = identifierType;
        this.cachedHashCode = null;
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public void setIdentifierName(String identifierName) {
        this.identifierName = identifierName;
        this.cachedPrintableName = null;
        this.cachedHashCode = null;
    }

    public String toString() {
        return this.identifierName + " (" + (Object)((Object)this.identifierType) + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Identifier)) {
            return false;
        }
        Identifier i = (Identifier)o;
        return this.identifierType.equals((Object)i.getIdentifierType()) && this.identifierName.equalsIgnoreCase(i.getIdentifierName());
    }

    public String getPrintableName() {
        if (this.cachedPrintableName == null) {
            String printableIdentifierName = this.identifierName.toLowerCase();
            if (this.identifierType == IdentifierType.BUILTIN) {
                Enum builtInIdentifier2;
                try {
                    builtInIdentifier2 = BuiltInPrincipalIdentifiers.forName(printableIdentifierName);
                    if (builtInIdentifier2 != null) {
                        printableIdentifierName = builtInIdentifier2.toString().toLowerCase();
                    }
                }
                catch (Exception builtInIdentifier2) {
                    // empty catch block
                }
                try {
                    builtInIdentifier2 = BuiltInScopeIdentifiers.forName(printableIdentifierName);
                    if (builtInIdentifier2 != null) {
                        printableIdentifierName = builtInIdentifier2.toString().toLowerCase();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.cachedPrintableName = printableIdentifierName;
        }
        return this.cachedPrintableName;
    }

    public int hashCode() {
        if (this.cachedHashCode == null) {
            this.cachedHashCode = this.identifierName.toLowerCase().hashCode() * this.identifierType.hashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    public int compareTo(@NotNull Identifier o) {
        return this.identifierType.compareTo(o.identifierType) * 1000 + this.getPrintableName().compareTo(o.getPrintableName());
    }
}

