/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.securitypolicy;

import com.nuix.automate.utils.api.internal.permission.Permission;
import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.models.api.audit.AuditEvent;
import com.nuix.automate.utils.models.api.securitypolicy.Identifier;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SecurityPolicy
extends UserPermissionModel {
    @Schema(description="Security Policy ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Security Policy Name", example="Default Access")
    private String name;
    @Schema(description="Security Policy Description", example="Policy providing default access to new users")
    private String description;
    @Schema(description="Is Security Policy Enabled?", example="true")
    private Boolean enabled;
    @Schema(description="Is Security Policy Read-Only?", example="true")
    protected boolean readOnly;
    @Schema(description="Security Policy Warning Messages")
    private Set<String> warnings;
    @Schema(description="Does Security Policy have warnings?", example="false")
    private boolean hasWarnings;
    @Schema(description="Principals")
    private TreeSet<Identifier> principals;
    @Schema(description="Scope")
    private TreeSet<Identifier> scope;
    @Schema(description="Permissions")
    private TreeSet<Permission> permissions;
    @Schema(description="Audit Log")
    private List<AuditEvent> auditLog;

    public SecurityPolicy() {
    }

    public SecurityPolicy(SecurityPolicy p) {
        this.id = p.getId();
        this.name = p.getName();
        this.description = p.getDescription();
        this.enabled = p.getEnabled();
        this.hasWarnings = p.isHasWarnings();
        this.principals = new TreeSet();
        if (p.getPrincipals() != null) {
            this.principals.addAll(p.getPrincipals());
        }
        this.scope = new TreeSet();
        if (p.getScope() != null) {
            this.scope.addAll(p.getScope());
        }
        this.permissions = new TreeSet();
        if (p.getPermissions() != null) {
            this.permissions.addAll(p.getPermissions());
        }
        this.warnings = new TreeSet<String>();
        if (p.getWarnings() != null) {
            this.warnings.addAll(p.getWarnings());
        }
        this.readOnly = p.getReadOnly();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public TreeSet<Identifier> getPrincipals() {
        return this.principals;
    }

    public void setPrincipals(Set<Identifier> principals) {
        this.principals = new TreeSet<Identifier>(principals);
    }

    public TreeSet<Identifier> getScope() {
        return this.scope;
    }

    public void setScope(Set<Identifier> scope) {
        this.scope = new TreeSet<Identifier>(scope);
    }

    public TreeSet<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(Set<Permission> permissions) {
        this.permissions = new TreeSet<Permission>(permissions);
    }

    public List<AuditEvent> getAuditLog() {
        if (this.auditLog == null) {
            this.auditLog = new ArrayList<AuditEvent>();
        }
        return this.auditLog;
    }

    public void setAuditLog(List<AuditEvent> auditLog) {
        this.auditLog = auditLog;
    }

    public Set<String> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(Set<String> warnings) {
        this.warnings = warnings;
    }

    public boolean isHasWarnings() {
        return this.hasWarnings;
    }

    public void setHasWarnings(boolean hasWarnings) {
        this.hasWarnings = hasWarnings;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Policy " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
        if (this.getEnabled() == null) {
            this.setEnabled(false);
        }
        if (this.getPermissions() == null) {
            this.setPermissions(new HashSet<Permission>());
        }
        if (this.getPrincipals() == null) {
            this.setPrincipals(new HashSet<Identifier>());
        }
        if (this.getScope() == null) {
            this.setScope(new HashSet<Identifier>());
        }
        if (this.getWarnings() == null) {
            this.setWarnings(new HashSet<String>());
        }
    }

    public SecurityPolicy cloneLimited() {
        SecurityPolicy limited = new SecurityPolicy();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.enabled = this.enabled;
        limited.setUserPermissions(this.cloneUserPermissions());
        limited.principals = new TreeSet();
        limited.permissions = new TreeSet();
        limited.scope = new TreeSet();
        limited.readOnly = this.readOnly;
        return limited;
    }
}

