/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.server;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.server.MaintenanceStatus;
import com.nuix.automate.utils.models.api.server.ServerStatus;
import com.nuix.automate.utils.security.SecurityUtils;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class Server
extends UserPermissionModel
implements Serializable {
    @Schema(description="Server ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Server Name", example="Server A")
    private String name;
    @Schema(description="Server Description", example="Sample description")
    private String description;
    @Schema(description="Server URL", example="https://serverA.local")
    private String url;
    @Schema(description="Server Status")
    private ServerStatus status;
    @Schema(description="Server Error Message", example="Cannot connect to server")
    private String error;
    @Schema(description="Server Version", example="5.0.0-preview01")
    private String version;
    @Schema(description="Server Java Version", example="Eclipse Foundation 11.0.12+7 OpenJDK 64-Bit Server VM")
    private String javaVersion;
    @Schema(description="Server Maintenance Status")
    private MaintenanceStatus maintenanceStatus;
    @Schema(description="Server Online Since (Epoch)", example="1641034800000")
    private transient Long onlineSince;
    @Schema(description="Server Last Seen Online (Epoch)", example="1641034800000")
    private transient Long onlineLastSeen;
    @Schema(description="Server Whitelisted Certificates Fingerprints (SHA-512)", example="[\"e62dd01ca608c10402d07714cfd626bfc6b1001e5a16ca039d1050a71f73ee24\",\"d5129635a050f63dd607ffa9271eefaab597c0975809765dad253973fc554d25\"]")
    private Set<String> whitelistedCertFingerprints;
    @Schema(description="Server Tags", ref="#/components/schemas/Tags")
    private Map<String, String> tags;

    public Server() {
    }

    public Server(Server copy) {
        this.id = copy.id;
        this.name = copy.name;
        this.description = copy.description;
        this.url = copy.url;
        this.status = copy.status;
        this.error = copy.error;
        this.version = copy.version;
        this.javaVersion = copy.javaVersion;
        this.maintenanceStatus = copy.maintenanceStatus;
        this.onlineSince = copy.onlineSince;
        this.onlineLastSeen = copy.onlineLastSeen;
        this.whitelistedCertFingerprints = new HashSet<String>();
        if (copy.whitelistedCertFingerprints != null) {
            this.whitelistedCertFingerprints.addAll(copy.whitelistedCertFingerprints);
        }
        this.tags = new HashMap<String, String>();
        if (copy.tags != null) {
            this.tags.putAll(copy.tags);
        }
    }

    public Set<String> getWhitelistedCertFingerprints() {
        return this.whitelistedCertFingerprints;
    }

    public void setWhitelistedCertFingerprints(Set<String> fingerprints) {
        this.whitelistedCertFingerprints = fingerprints;
    }

    public Long getOnlineSince() {
        return this.onlineSince;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStatus(ServerStatus status) {
        if (status == ServerStatus.INITIALIZED) {
            if (this.onlineSince == null) {
                this.onlineSince = new DateTime(DateTimeZone.UTC).getMillis();
            }
        } else {
            this.onlineSince = null;
        }
        this.status = status;
    }

    public void setError(String error) {
        this.error = error;
    }

    public String getError() {
        return this.error;
    }

    public ServerStatus getStatus() {
        return this.status;
    }

    public String toString() {
        return "Server " + this.name + " (" + FormattingUtils.getShortId(this.id, 8) + ")";
    }

    public MaintenanceStatus getMaintenanceStatus() {
        return this.maintenanceStatus;
    }

    public void setMaintenanceStatus(MaintenanceStatus maintenanceStatus) {
        this.maintenanceStatus = maintenanceStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Long getOnlineLastSeen() {
        return this.onlineLastSeen;
    }

    public void setOnlineLastSeen(Long onlineLastSeen) {
        this.onlineLastSeen = onlineLastSeen;
    }

    public void setDefaults() {
        if (this.getName() == null) {
            this.setName("Server " + this.getId());
        }
        if (this.getDescription() == null) {
            this.setDescription("");
        }
    }

    public String getJavaVersion() {
        return this.javaVersion;
    }

    public void setJavaVersion(String javaVersion) {
        this.javaVersion = javaVersion;
    }

    public Server cloneLimited() {
        Server limited = new Server();
        limited.id = this.id;
        limited.name = this.name;
        limited.description = this.description;
        limited.setUserPermissions(this.cloneUserPermissions());
        limited.status = this.status;
        if (this.error != null && this.error.length() > 0) {
            limited.error = FormattingUtils.constantToCamelCaseFirstUpper("ERROR") + " Code " + SecurityUtils.computeShortSha256Hex("Status message" + this.error);
        }
        limited.whitelistedCertFingerprints = new HashSet<String>();
        return limited;
    }

    public void normalize() {
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }
}

