/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.smtp;

import com.nuix.automate.utils.api.response.Status;
import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.api.smtp.EmailState;
import com.nuix.automate.utils.models.api.smtp.SmtpEmail;
import java.util.concurrent.atomic.AtomicLong;

public class SmtpEmailCounter {
    private static final InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    private String initiatorId;
    private Status status;
    private AtomicLong pendingEmailCount;
    private AtomicLong sentEmailCount;
    private AtomicLong errorEmailCount;
    private AtomicLong purgedEmailCount;

    public SmtpEmailCounter(String initiatorId) {
        this.initiatorId = initiatorId;
        this.status = new Status();
        this.pendingEmailCount = new AtomicLong();
        this.sentEmailCount = new AtomicLong();
        this.errorEmailCount = new AtomicLong();
        this.purgedEmailCount = new AtomicLong();
    }

    public void trackSubmit(SmtpEmail smtpEmail) {
        if (smtpEmail.getState() == EmailState.ERROR) {
            this.errorEmailCount.decrementAndGet();
        }
        this.pendingEmailCount.incrementAndGet();
    }

    public void trackComplete(SmtpEmail smtpEmail) {
        this.pendingEmailCount.decrementAndGet();
        if (smtpEmail.getState() == EmailState.ERROR) {
            this.errorEmailCount.incrementAndGet();
        } else if (smtpEmail.getState() == EmailState.SENT) {
            this.sentEmailCount.incrementAndGet();
        } else if (smtpEmail.getState() == EmailState.PURGED) {
            this.purgedEmailCount.incrementAndGet();
        }
        this.updateStatus();
    }

    public synchronized void updateStatus() {
        if (this.errorEmailCount.get() > 0L) {
            this.status.setWarningMessage(iu.getNumeralString("SmtpServiceSession.Error.SmtpHasFailedToSendEmails", this.errorEmailCount.get()));
        } else {
            this.status.reset();
        }
    }

    public void setPendingEmailCount(long count) {
        this.pendingEmailCount.set(count);
    }

    public void setSentEmailCount(long count) {
        this.sentEmailCount.set(count);
    }

    public void setErrorEmailCount(long count) {
        this.errorEmailCount.set(count);
        this.updateStatus();
    }

    public void setPurgedEmailCount(long count) {
        this.purgedEmailCount.set(count);
    }

    public String getInitiatorId() {
        return this.initiatorId;
    }

    public Status getStatus() {
        return this.status;
    }

    public AtomicLong getPendingEmailCount() {
        return this.pendingEmailCount;
    }

    public AtomicLong getSentEmailCount() {
        return this.sentEmailCount;
    }

    public AtomicLong getErrorEmailCount() {
        return this.errorEmailCount;
    }

    public AtomicLong getPurgedEmailCount() {
        return this.purgedEmailCount;
    }

    public void setInitiatorId(String initiatorId) {
        this.initiatorId = initiatorId;
    }

    public void setStatus(Status status) {
        this.status = status;
    }
}

