/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.thirdparty.JwtTokenUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;

public class DerbyControlService
extends ThirdPartyService {
    @Schema(description="URL", example="http://127.0.0.1:8999/DERBY-CONTROL")
    private String url;

    @Override
    public void update(ThirdPartyService thirdPartyService) {
        super.update(thirdPartyService);
        DerbyControlService derbyControlService = (DerbyControlService)thirdPartyService;
        if (derbyControlService.getUrl() != null) {
            this.setUrl(derbyControlService.getUrl());
        }
    }

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.url != null) {
            this.url = FormattingUtils.getNonEmptyTrimmedText(this.url);
            if (this.url == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("UrlMissing"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new JwtTokenUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{derby_control_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.DERBY_CONTROL_SERVICE;
    }

    @Override
    public AuthMethodType getOidcAuthMethodType() {
        return AuthMethodType.OIDC;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Collections.singletonList(ThirdPartyAuthenticationMethod.OIDC_CLIENT_CREDENTIALS);
    }

    @Override
    public void normalize() {
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "Derby Control Service";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

