/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.thirdparty.DiscoverUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;

public class DiscoverService
extends ThirdPartyService {
    @Schema(description="Host name", example="ringtail.us.nuix.com")
    public String hostname;

    public DiscoverService() {
    }

    public DiscoverService(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public boolean isPlatformApplication() {
        return true;
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new DiscoverUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{discover_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.DISCOVER_SERVICE;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Collections.singletonList(ThirdPartyAuthenticationMethod.API_KEY);
    }

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.hostname != null) {
            this.hostname = FormattingUtils.getNonEmptyTrimmedText(this.hostname);
            if (this.hostname == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("HostnameMissing"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public boolean updateUserCredentialSensitiveFields(ThirdPartyService thirdPartyService) {
        boolean userCredentialStale = super.updateUserCredentialSensitiveFields(thirdPartyService);
        DiscoverService discoverService = (DiscoverService)thirdPartyService;
        if (discoverService.getHostname() != null) {
            userCredentialStale = userCredentialStale || !discoverService.getHostname().equals(this.hostname);
            this.setHostname(discoverService.getHostname());
        }
        return userCredentialStale;
    }

    @Override
    public ThirdPartyService cloneLimited() {
        DiscoverService limited = new DiscoverService();
        limited.applyLimitedSettingsFrom(this);
        return limited;
    }

    @Override
    public void normalize() {
        if (this.hostname != null) {
            this.hostname = this.hostname.trim();
            try {
                this.hostname = FormattingUtils.getHostnameFromUrl(this.hostname);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "Nuix Discover";
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }
}

