/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.thirdparty.GraphUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;

public class GraphService
extends ThirdPartyService {
    @Schema(description="URL", example="bolt://127.0.0.1:7687")
    private String url;

    @Override
    public void update(ThirdPartyService thirdPartyService) {
        super.update(thirdPartyService);
        GraphService graphService = (GraphService)thirdPartyService;
        if (graphService.getUrl() != null) {
            this.setUrl(graphService.getUrl());
        }
    }

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.url != null) {
            this.url = FormattingUtils.getNonEmptyTrimmedText(this.url);
            if (this.url == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("UrlMissing"), Response.Status.BAD_REQUEST));
            }
            if (!this.url.toLowerCase().startsWith("bolt://")) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidBoltUrl"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new GraphUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{knowledge_graph_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.GRAPH_SERVICE;
    }

    @Override
    public AuthMethodType getOidcAuthMethodType() {
        return AuthMethodType.USERNAME_PASSWORD;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Arrays.asList(ThirdPartyAuthenticationMethod.NONE, ThirdPartyAuthenticationMethod.USERNAME_PASSWORD);
    }

    @Override
    public void normalize() {
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url, "bolt", 7687);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        ThirdPartyUserCredential userCredential = this.getUserCredential();
        if (this.getAuthenticationMethod() != null && this.getAuthenticationMethod().equals((Object)ThirdPartyAuthenticationMethod.NONE) && userCredential != null) {
            userCredential.setPassword("");
            userCredential.setUsername("");
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "Graph Service";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

