/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.thirdparty.JwtTokenUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;

public class InvestigateService
extends ThirdPartyService {
    @Schema(description="URL", example="https://neo.nuix.com:8999/INVESTIGATE")
    private String url;
    @Schema(description="Service URL", example="http://127.0.0.1:8999/INVESTIGATE")
    private String serviceUrl;

    @Override
    public boolean isPlatformApplication() {
        return true;
    }

    @Override
    public void update(ThirdPartyService thirdPartyService) {
        super.update(thirdPartyService);
        InvestigateService investigateService = (InvestigateService)thirdPartyService;
        if (investigateService.getUrl() != null) {
            this.setUrl(investigateService.getUrl());
        }
        if (investigateService.getServiceUrl() != null) {
            this.setServiceUrl(investigateService.getServiceUrl());
        }
    }

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.url != null) {
            this.url = FormattingUtils.getNonEmptyTrimmedText(this.url);
            if (this.url == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("UrlMissing"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new JwtTokenUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{investigate_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return null;
    }

    @Override
    public AuthMethodType getOidcAuthMethodType() {
        return AuthMethodType.OIDC;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Collections.singletonList(ThirdPartyAuthenticationMethod.OIDC_CLIENT_CREDENTIALS);
    }

    @Override
    public void normalize() {
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url) + "/INVESTIGATE";
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (this.serviceUrl != null) {
            this.serviceUrl = this.serviceUrl.trim();
            if (!this.serviceUrl.isEmpty()) {
                try {
                    this.serviceUrl = FormattingUtils.getUrlFromHostname(this.serviceUrl) + "/INVESTIGATE";
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "Nuix Investigate Service";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public String getServiceUrlOrUrl() {
        if (this.serviceUrl != null && !this.serviceUrl.trim().isEmpty()) {
            return this.serviceUrl;
        }
        return this.url;
    }
}

