/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.thirdparty.DummyUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;

public class LinkService
extends ThirdPartyService {
    @Schema(description="External Service URL", example="https://external.com:8080")
    private String url;

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.url != null) {
            this.url = FormattingUtils.getNonEmptyTrimmedText(this.url);
            if (this.url == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("UrlMissing"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public void update(ThirdPartyService thirdPartyService) {
        super.update(thirdPartyService);
        LinkService linkService = (LinkService)thirdPartyService;
        if (linkService.getUrl() != null) {
            this.setUrl(linkService.getUrl());
        }
    }

    @Override
    public void normalize() {
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new DummyUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return null;
    }

    @Override
    public ParameterType getParameterType() {
        return null;
    }

    @Override
    public List<ThirdPartyAuthenticationScope> getAllowedAuthenticationScopes() {
        return Collections.singletonList(ThirdPartyAuthenticationScope.SERVICE);
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Collections.singletonList(ThirdPartyAuthenticationMethod.NONE);
    }

    @Override
    public String getPrintableServiceType() {
        return "Link Service";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

