/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.thirdparty.NlpUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;

public class NlpService
extends ThirdPartyService {
    private String hostname;
    @Schema(description="URL", example="https://nlp.nuix.com")
    private String url;
    @Schema(description="Feeds API URL", example="https://nlp.nuix.com:14410")
    private String feedsApiUrl;
    @Schema(description="Job Control URL", example="https://nlp.nuix.com/api/jobs/graphql")
    private String jobControlUrl;

    @Override
    public boolean isPlatformApplication() {
        return true;
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new NlpUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{nlp_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.NLP_SERVICE;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Collections.singletonList(ThirdPartyAuthenticationMethod.API_KEY);
    }

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.url != null) {
            this.url = FormattingUtils.getNonEmptyTrimmedText(this.url);
            if (this.url == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("UrlMissing"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public boolean updateUserCredentialSensitiveFields(ThirdPartyService thirdPartyService) {
        boolean userCredentialStale = super.updateUserCredentialSensitiveFields(thirdPartyService);
        NlpService nlpService = (NlpService)thirdPartyService;
        if (nlpService.getUrl() != null) {
            userCredentialStale = userCredentialStale || !nlpService.getUrl().equals(this.url);
            this.setUrl(nlpService.getUrl());
        }
        if (nlpService.getFeedsApiUrl() != null) {
            userCredentialStale = userCredentialStale || !nlpService.getFeedsApiUrl().equals(this.feedsApiUrl);
            this.setFeedsApiUrl(nlpService.getFeedsApiUrl());
        }
        if (nlpService.getJobControlUrl() != null) {
            userCredentialStale = userCredentialStale || !nlpService.getJobControlUrl().equals(this.jobControlUrl);
            this.setJobControlUrl(nlpService.getJobControlUrl());
        }
        return userCredentialStale;
    }

    @Override
    public void normalize() {
        if (this.hostname != null) {
            this.url = this.hostname;
            this.hostname = null;
        }
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (this.feedsApiUrl != null) {
            this.feedsApiUrl = this.feedsApiUrl.trim();
            if (!this.feedsApiUrl.isEmpty()) {
                try {
                    this.feedsApiUrl = FormattingUtils.getUrlFromHostname(this.feedsApiUrl) + ":14410";
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        if (this.jobControlUrl != null) {
            this.jobControlUrl = this.jobControlUrl.trim();
            if (!this.jobControlUrl.isEmpty()) {
                try {
                    this.jobControlUrl = FormattingUtils.getUrlFromHostname(this.jobControlUrl) + "/api/jobs/graphql";
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "Nuix NLP";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getFeedsApiUrl() {
        return this.feedsApiUrl;
    }

    public String getEffectiveFeedsApiUrl() {
        if (this.feedsApiUrl != null && this.feedsApiUrl.length() > 0) {
            return this.feedsApiUrl;
        }
        try {
            return "https://" + FormattingUtils.getHostnameFromUrl(this.url) + ":14410";
        }
        catch (URISyntaxException e) {
            return this.url;
        }
    }

    public String getEffectiveJobControlUrl() {
        if (this.jobControlUrl != null && this.jobControlUrl.length() > 0) {
            return this.jobControlUrl;
        }
        try {
            return "https://" + FormattingUtils.getHostnameFromUrl(this.url) + "/api/jobs/graphql";
        }
        catch (URISyntaxException e) {
            return this.url;
        }
    }

    public void setFeedsApiUrl(String feedsApiUrl) {
        this.feedsApiUrl = feedsApiUrl;
    }

    @Deprecated
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getJobControlUrl() {
        return this.jobControlUrl;
    }

    public void setJobControlUrl(String jobControlUrl) {
        this.jobControlUrl = jobControlUrl;
    }
}

