/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.relativity.EndpointType;
import com.nuix.automate.utils.models.api.relativity.RelativityRestVersion;
import com.nuix.automate.utils.models.api.thirdparty.RelativityUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;

public class RelativityService
extends ThirdPartyService {
    @Schema(description="Host Name", example="service.relativity.com")
    private String hostname;
    @Schema(description="Service Endpoint", example="/relativitywebapi")
    private String serviceEndpoint;
    @Schema(description="Endpoint Type")
    private EndpointType endpointType;
    @Schema(description="Import Threads Count", example="1")
    private Integer importThreads;
    @Schema(description="Import Thread Timeout Seconds", example="3600")
    private Integer importThreadTimeout;
    @Schema(description="Import Thread Retries", example="3")
    private Integer importThreadRetries;
    @Schema(description="Metadata Thread Count", example="8")
    private Integer metadataThreads;
    @Schema(description="Patch Invalid Entries", example="False")
    private Boolean patchInvalidEntries;
    @Schema(description="Relativity REST Version", example="REST_V1")
    private RelativityRestVersion relativityRestVersion;
    @Schema(description="Use Custom Client Version", example="True")
    private Boolean useCustomClientVersion;
    @Schema(description="Custom Client Version", example="Latest")
    private String customClientVersion;

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new RelativityUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{relativity_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.RELATIVITY_SERVICE;
    }

    @Override
    public AuthMethodType getOidcAuthMethodType() {
        return AuthMethodType.OIDC_RELATIVITY;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Arrays.asList(ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE, ThirdPartyAuthenticationMethod.USERNAME_PASSWORD);
    }

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.hostname != null) {
            this.hostname = FormattingUtils.getNonEmptyTrimmedText(this.hostname);
            if (this.hostname == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("HostNameMissing"), Response.Status.BAD_REQUEST));
            }
        }
        if (!edit || this.serviceEndpoint != null) {
            this.serviceEndpoint = FormattingUtils.getNonEmptyTrimmedText(this.serviceEndpoint);
            if (this.serviceEndpoint == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("ServiceEndpointMissing"), Response.Status.BAD_REQUEST));
            }
        }
        if (Boolean.TRUE.equals(this.useCustomClientVersion) && (!edit || this.customClientVersion != null)) {
            this.customClientVersion = FormattingUtils.getNonEmptyTrimmedText(this.customClientVersion);
            if (this.customClientVersion == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("CustomClientVersionMissing"), Response.Status.BAD_REQUEST));
            }
        }
        if (!(edit && this.importThreads == null || this.importThreads > 0)) {
            throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidImportThreads"), Response.Status.BAD_REQUEST));
        }
        if (!(edit && this.importThreadTimeout == null || this.importThreadTimeout > 0)) {
            throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidImportThreadTimeout"), Response.Status.BAD_REQUEST));
        }
        if (!(edit && this.importThreadRetries == null || this.importThreadRetries >= 0)) {
            throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidImportThreadRetries"), Response.Status.BAD_REQUEST));
        }
        if (!(edit && this.metadataThreads == null || this.metadataThreads > 0)) {
            throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidMetadataThreads"), Response.Status.BAD_REQUEST));
        }
    }

    @Override
    public void update(ThirdPartyService thirdPartyService) {
        super.update(thirdPartyService);
        RelativityService relativityService = (RelativityService)thirdPartyService;
        if (relativityService.getEndpointType() != null) {
            this.setEndpointType(relativityService.getEndpointType());
        }
        if (relativityService.getRelativityRestVersion() != null) {
            this.setRelativityRestVersion(relativityService.getRelativityRestVersion());
        }
        if (relativityService.getImportThreads() != null) {
            this.setImportThreads(relativityService.getImportThreads());
        }
        if (relativityService.getImportThreadTimeout() != null) {
            this.setImportThreadTimeout(relativityService.getImportThreadTimeout());
        }
        if (relativityService.getImportThreadRetries() != null) {
            this.setImportThreadRetries(relativityService.getImportThreadRetries());
        }
        if (relativityService.getMetadataThreads() != null) {
            this.setMetadataThreads(relativityService.getMetadataThreads());
        }
        if (relativityService.getPatchInvalidEntries() != null) {
            this.setPatchInvalidEntries(relativityService.getPatchInvalidEntries());
        }
        if (relativityService.getUseCustomClientVersion() != null) {
            this.setUseCustomClientVersion(relativityService.getUseCustomClientVersion());
        }
        if (relativityService.getCustomClientVersion() != null) {
            this.setCustomClientVersion(relativityService.getCustomClientVersion());
        }
    }

    @Override
    public boolean updateUserCredentialSensitiveFields(ThirdPartyService thirdPartyService) {
        boolean userCredentialStale = super.updateUserCredentialSensitiveFields(thirdPartyService);
        RelativityService relativityService = (RelativityService)thirdPartyService;
        if (relativityService.getHostname() != null) {
            userCredentialStale = userCredentialStale || !relativityService.getHostname().equals(this.hostname);
            this.setHostname(relativityService.getHostname());
        }
        if (relativityService.getServiceEndpoint() != null) {
            userCredentialStale = userCredentialStale || !relativityService.getServiceEndpoint().equals(this.serviceEndpoint);
            this.setServiceEndpoint(relativityService.getServiceEndpoint());
        }
        return userCredentialStale;
    }

    @Override
    public ThirdPartyService cloneLimited() {
        RelativityService limited = new RelativityService();
        limited.applyLimitedSettingsFrom(this);
        return limited;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public void setServiceEndpoint(String serviceEndpoint) {
        this.serviceEndpoint = serviceEndpoint;
    }

    public EndpointType getEndpointType() {
        return this.endpointType;
    }

    public void setEndpointType(EndpointType endpointType) {
        this.endpointType = endpointType;
    }

    public Integer getImportThreads() {
        return this.importThreads;
    }

    public void setImportThreads(Integer importThreads) {
        this.importThreads = importThreads;
    }

    public Integer getImportThreadTimeout() {
        return this.importThreadTimeout;
    }

    public void setImportThreadTimeout(Integer importThreadTimeout) {
        this.importThreadTimeout = importThreadTimeout;
    }

    public Integer getImportThreadRetries() {
        return this.importThreadRetries;
    }

    public void setImportThreadRetries(Integer importThreadRetries) {
        this.importThreadRetries = importThreadRetries;
    }

    public Integer getMetadataThreads() {
        return this.metadataThreads;
    }

    public void setMetadataThreads(Integer metadataThreads) {
        this.metadataThreads = metadataThreads;
    }

    public Boolean getPatchInvalidEntries() {
        return this.patchInvalidEntries;
    }

    public void setPatchInvalidEntries(Boolean patchInvalidEntries) {
        this.patchInvalidEntries = patchInvalidEntries;
    }

    public RelativityRestVersion getRelativityRestVersion() {
        return this.relativityRestVersion;
    }

    public void setRelativityRestVersion(RelativityRestVersion relativityRestVersion) {
        this.relativityRestVersion = relativityRestVersion;
    }

    public Boolean getUseCustomClientVersion() {
        return this.useCustomClientVersion;
    }

    public void setUseCustomClientVersion(Boolean useCustomClientVersion) {
        this.useCustomClientVersion = useCustomClientVersion;
    }

    public String getCustomClientVersion() {
        return this.customClientVersion;
    }

    public void setCustomClientVersion(String customClientVersion) {
        this.customClientVersion = customClientVersion;
    }

    @Override
    public void normalize() {
        if (this.hostname != null) {
            this.hostname = this.hostname.trim();
            try {
                this.hostname = FormattingUtils.getHostnameFromUrl(this.hostname);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "Relativity";
    }
}

