/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.thirdparty.DummyUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;

public class SemanticService
extends ThirdPartyService {
    @Schema(description="URL", example="http://semantic.nuix.com:8080")
    private String url;

    public SemanticService() {
    }

    public SemanticService(String hostname) {
        this.url = hostname;
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new DummyUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{semantic_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.SEMANTIC_SERVICE;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Arrays.asList(ThirdPartyAuthenticationMethod.NONE);
    }

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.url != null) {
            this.url = FormattingUtils.getNonEmptyTrimmedText(this.url);
            if (this.url == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("UrlMissing"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public void update(ThirdPartyService thirdPartyService) {
        super.update(thirdPartyService);
        SemanticService semanticService = (SemanticService)thirdPartyService;
        if (semanticService.getUrl() != null) {
            this.setUrl(semanticService.getUrl());
        }
    }

    @Override
    public ThirdPartyService cloneLimited() {
        SemanticService limited = new SemanticService();
        limited.applyLimitedSettingsFrom(this);
        return limited;
    }

    @Override
    public void normalize() {
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        ThirdPartyUserCredential userCredential = this.getUserCredential();
        if (this.getAuthenticationMethod() != null && this.getAuthenticationMethod().equals((Object)ThirdPartyAuthenticationMethod.NONE) && userCredential != null) {
            userCredential.setToken("");
            userCredential.setPassword("");
            userCredential.setUsername("");
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "Semantic";
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

