/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.smtp.SmtpEmailCounter;
import com.nuix.automate.utils.models.api.thirdparty.SmtpUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.Response;

public class SmtpService
extends ThirdPartyService {
    @Schema(description="SMTP Server Host", example="mail.outlook.com")
    private String host;
    @Schema(description="SMTP Server Port", example="587")
    private Integer port;
    @Schema(description="Is the SMTP Server Connection over TLS?", example="true")
    private Boolean tls;
    @Schema(description="Email From", example="jsmith@example.com")
    private String from;
    @Schema(description="Email Retry Interval (Hours)", example="12")
    private Integer emailRetryInterval;
    @Schema(description="Email Max Retries", example="12")
    private Integer emailMaxAttempts;
    @Schema(description="Consumption Tracking Epoch")
    private SmtpEmailCounter emailCounter;
    private transient long lastReattemptSeconds;

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!this.usingOidcAuthenticationMethod()) {
            if (!edit || this.host != null) {
                this.host = FormattingUtils.getNonEmptyTrimmedText(this.host);
                if (this.host == null) {
                    throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("HostMissing"), Response.Status.BAD_REQUEST));
                }
            }
            if (!(edit && this.port == null || this.port != null && this.port >= 0)) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("PortMissing"), Response.Status.BAD_REQUEST));
            }
        }
        if (!edit || this.from != null) {
            this.from = FormattingUtils.getNonEmptyTrimmedText(this.from);
            if (this.from == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("FromMissing"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public void update(ThirdPartyService thirdPartyService) {
        super.update(thirdPartyService);
        SmtpService smtpService = (SmtpService)thirdPartyService;
        if (smtpService.getTls() != null) {
            this.setTls(smtpService.getTls());
        }
        if (smtpService.getFrom() != null) {
            this.setFrom(smtpService.getFrom());
        }
        if (smtpService.getEmailRetryInterval() != null) {
            this.setEmailRetryInterval(smtpService.getEmailRetryInterval());
        }
        if (smtpService.getEmailMaxAttempts() != null) {
            this.setEmailMaxAttempts(smtpService.getEmailMaxAttempts());
        }
    }

    @Override
    public boolean updateUserCredentialSensitiveFields(ThirdPartyService thirdPartyService) {
        boolean userCredentialStale = super.updateUserCredentialSensitiveFields(thirdPartyService);
        SmtpService smtpService = (SmtpService)thirdPartyService;
        if (!this.usingOidcAuthenticationMethod()) {
            if (smtpService.getHost() != null) {
                userCredentialStale = userCredentialStale || !smtpService.getHost().equals(this.host);
                this.setHost(smtpService.getHost());
            }
            if (smtpService.getPort() != null) {
                userCredentialStale = userCredentialStale || !smtpService.getPort().equals(this.port);
                this.setPort(smtpService.getPort());
            }
        }
        return userCredentialStale;
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new SmtpUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{smtp_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.SMTP_SERVICE;
    }

    @Override
    public List<ThirdPartyAuthenticationScope> getAllowedAuthenticationScopes() {
        return Collections.singletonList(ThirdPartyAuthenticationScope.SERVICE);
    }

    @Override
    public AuthMethodType getOidcAuthMethodType() {
        return AuthMethodType.OIDC_MICROSOFT;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Arrays.asList(ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE, ThirdPartyAuthenticationMethod.USERNAME_PASSWORD, ThirdPartyAuthenticationMethod.NONE);
    }

    @Override
    public void normalize() {
        if (!this.usingOidcAuthenticationMethod()) {
            this.host = FormattingUtils.getTrimmedText(this.host);
            if (this.host != null) {
                try {
                    this.host = FormattingUtils.getHostnameFromUrl(this.host);
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getPrintableServiceType() {
        return "SMTP Service";
    }

    public String getHost() {
        return this.host;
    }

    public Integer getPort() {
        return this.port;
    }

    public Boolean getTls() {
        return this.tls;
    }

    public String getFrom() {
        return this.from;
    }

    public Integer getEmailRetryInterval() {
        return this.emailRetryInterval;
    }

    public Integer getEmailMaxAttempts() {
        return this.emailMaxAttempts;
    }

    public SmtpEmailCounter getEmailCounter() {
        return this.emailCounter;
    }

    public long getLastReattemptSeconds() {
        return this.lastReattemptSeconds;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setTls(Boolean tls) {
        this.tls = tls;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setEmailRetryInterval(Integer emailRetryInterval) {
        this.emailRetryInterval = emailRetryInterval;
    }

    public void setEmailMaxAttempts(Integer emailMaxAttempts) {
        this.emailMaxAttempts = emailMaxAttempts;
    }

    public void setEmailCounter(SmtpEmailCounter emailCounter) {
        this.emailCounter = emailCounter;
    }

    public void setLastReattemptSeconds(long lastReattemptSeconds) {
        this.lastReattemptSeconds = lastReattemptSeconds;
    }
}

