/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.api.internal.permission.UserPermissionModel;
import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.internal.user.AuthMethodType;
import com.nuix.automate.utils.security.policies.ApplicationFeatures;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;

public abstract class ThirdPartyService
extends UserPermissionModel {
    @Schema(description="ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="ID", example="11111111-1111-1111-1111-111111111111")
    private String id2;
    @Schema(description="Name", example="3rd Service")
    private String name;
    @Schema(description="Description", example="Lorem Ipsum")
    private String description;
    @Schema(description="Enabled", example="True")
    private Boolean enabled;
    @Schema(description="Available By Default", example="False")
    private Boolean availableByDefault;
    @Schema(description="Authentication Scope")
    private ThirdPartyAuthenticationScope authenticationScope;
    @Schema(description="Authentication Method")
    private ThirdPartyAuthenticationMethod authenticationMethod;
    @Schema(description="Authentication Service ID", example="11111111-1111-1111-1111-111111111111")
    private String authenticationServiceId;
    @Schema(description="Whitelisted Certificates Fingerprints (SHA-512)", example="[\"e62dd01ca608c10402d07714cfd626bfc6b1001e5a16ca039d1050a71f73ee24\",\"d5129635a050f63dd607ffa9271eefaab597c0975809765dad253973fc554d25\"]")
    private Set<String> whitelistedCertFingerprints;
    private boolean readOnly;
    private ThirdPartyUserCredential userCredential;

    public abstract ThirdPartyUserCredential initializeDefaultUserCredential();

    public abstract String getDefaultParameterName();

    public abstract ParameterType getParameterType();

    public abstract List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods();

    public List<ThirdPartyAuthenticationScope> getAllowedAuthenticationScopes() {
        return Arrays.asList(ThirdPartyAuthenticationScope.values());
    }

    public AuthMethodType getOidcAuthMethodType() {
        return null;
    }

    public abstract String getPrintableServiceType();

    public void normalize() {
    }

    public ThirdPartyService cloneLimited() {
        try {
            ThirdPartyService thirdPartyService = (ThirdPartyService)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            thirdPartyService.applyLimitedSettingsFrom(this);
            return thirdPartyService;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    @Override
    public ThirdPartyService clone() {
        ThirdPartyService clone = (ThirdPartyService)super.clone();
        clone.whitelistedCertFingerprints = new HashSet<String>();
        if (this.whitelistedCertFingerprints != null) {
            clone.whitelistedCertFingerprints.addAll(this.whitelistedCertFingerprints);
        }
        return clone;
    }

    public boolean isPlatformApplication() {
        return false;
    }

    public ApplicationFeatures getViewFeature() {
        return null;
    }

    public ApplicationFeatures getAddFeature() {
        return null;
    }

    public void isValid(boolean edit) throws ResponseException {
        if (!edit) {
            this.name = FormattingUtils.getNonEmptyTrimmedText(this.name);
            if (this.name == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("NameMissing"), Response.Status.BAD_REQUEST));
            }
        }
        if (!(edit && this.authenticationScope == null || this.getAllowedAuthenticationScopes().contains((Object)this.authenticationScope))) {
            throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidAuthenticationScope"), Response.Status.BAD_REQUEST));
        }
        if (!(edit && this.authenticationMethod == null || this.getAllowedAuthenticationMethods().contains((Object)this.authenticationMethod))) {
            throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidAuthenticationMethod"), Response.Status.BAD_REQUEST));
        }
        if (this.usingOidcAuthenticationMethod() && (!edit || this.authenticationServiceId != null)) {
            this.authenticationServiceId = FormattingUtils.getNonEmptyTrimmedText(this.authenticationServiceId);
            if (this.authenticationServiceId == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("AuthenticationServiceIdMissing"), Response.Status.BAD_REQUEST));
            }
        }
    }

    public void update(ThirdPartyService thirdPartyService) {
        String description;
        String name = FormattingUtils.getTrimmedText(thirdPartyService.getName());
        if (name != null) {
            this.setName(name);
        }
        if ((description = FormattingUtils.getTrimmedText(thirdPartyService.getDescription())) != null) {
            this.setDescription(description);
        }
        if (thirdPartyService.getEnabled() != null) {
            this.setEnabled(thirdPartyService.getEnabled());
        }
        if (thirdPartyService.getAvailableByDefault() != null) {
            this.setAvailableByDefault(thirdPartyService.getAvailableByDefault());
        }
        if (thirdPartyService.getAuthenticationScope() != null) {
            this.setAuthenticationScope(thirdPartyService.getAuthenticationScope());
        }
        if (thirdPartyService.getWhitelistedCertFingerprints() != null) {
            Set<String> whitelistedCerts = FormattingUtils.normalizeCertificateFingerprints(thirdPartyService.getWhitelistedCertFingerprints());
            whitelistedCerts.remove("");
            this.setWhitelistedCertFingerprints(whitelistedCerts);
        }
        this.normalize();
    }

    public boolean updateUserCredentialSensitiveFields(ThirdPartyService thirdPartyService) {
        boolean userCredentialStale = false;
        if (thirdPartyService.getAuthenticationMethod() != null) {
            userCredentialStale = !thirdPartyService.getAuthenticationMethod().equals((Object)this.authenticationMethod);
            this.setAuthenticationMethod(thirdPartyService.getAuthenticationMethod());
        }
        if (thirdPartyService.getAuthenticationServiceId() != null) {
            userCredentialStale = userCredentialStale || !thirdPartyService.getAuthenticationServiceId().equals(this.authenticationServiceId);
            this.setAuthenticationServiceId(thirdPartyService.getAuthenticationServiceId());
        }
        return userCredentialStale;
    }

    public String getUiTranslationKey(String text) {
        String simpleName = this.getClass().getSimpleName();
        return simpleName.substring(0, 1).toLowerCase() + simpleName.substring(1) + text;
    }

    public boolean usingOidcAuthenticationMethod() {
        return this.authenticationMethod == ThirdPartyAuthenticationMethod.OIDC_AUTHORIZATION_CODE || this.authenticationMethod == ThirdPartyAuthenticationMethod.OIDC_CLIENT_CREDENTIALS;
    }

    public String getTranslationKey(String key) {
        return this.getClass().getSimpleName() + "." + key;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getAvailableByDefault() {
        return this.availableByDefault;
    }

    public void setAvailableByDefault(Boolean availableByDefault) {
        this.availableByDefault = availableByDefault;
    }

    public ThirdPartyAuthenticationScope getAuthenticationScope() {
        return this.authenticationScope;
    }

    public void setAuthenticationScope(ThirdPartyAuthenticationScope authenticationScope) {
        this.authenticationScope = authenticationScope;
    }

    public ThirdPartyAuthenticationMethod getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public void setAuthenticationMethod(ThirdPartyAuthenticationMethod authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public String getAuthenticationServiceId() {
        return this.authenticationServiceId;
    }

    public void setAuthenticationServiceId(String authenticationServiceId) {
        this.authenticationServiceId = authenticationServiceId;
    }

    public Set<String> getWhitelistedCertFingerprints() {
        return this.whitelistedCertFingerprints;
    }

    public void setWhitelistedCertFingerprints(Set<String> whitelistedCertFingerprints) {
        this.whitelistedCertFingerprints = whitelistedCertFingerprints;
    }

    public ThirdPartyUserCredential getUserCredential() {
        return this.userCredential;
    }

    public void setUserCredential(ThirdPartyUserCredential userCredential) {
        this.userCredential = userCredential;
    }

    protected void applyLimitedSettingsFrom(ThirdPartyService source) {
        this.id = source.id;
        this.name = source.name;
        this.description = source.description;
        this.enabled = source.enabled;
        this.availableByDefault = source.availableByDefault;
        this.authenticationScope = source.authenticationScope;
        this.authenticationMethod = source.authenticationMethod;
        this.authenticationServiceId = source.authenticationServiceId;
        this.userCredential = source.userCredential;
        this.setUserPermissions(source.cloneUserPermissions());
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }
}

