/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.general.InternationalizationUtils;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationScope;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.UserCredential;
import io.swagger.v3.oas.annotations.media.Schema;

public class ThirdPartyUserCredential
extends UserCredential {
    protected static final InternationalizationUtils iu = InternationalizationUtils.getInstance("SchedulerText");
    @Schema(description="Third Party Service ID", example="11111111-1111-1111-1111-111111111111")
    private String thirdPartyServiceId;
    @Schema(description="User ID", example="11111111-1111-1111-1111-111111111111")
    private String userId;
    @Schema(description="Authentication Scope")
    private ThirdPartyAuthenticationScope authenticationScope;

    @Override
    public ThirdPartyUserCredential clone() {
        return (ThirdPartyUserCredential)super.clone();
    }

    @Override
    public ThirdPartyUserCredential cloneNonSensitive() {
        ThirdPartyUserCredential clone = new ThirdPartyUserCredential();
        clone.copyNonSensitiveProperties(this);
        return clone;
    }

    public void copyNonSensitiveProperties(ThirdPartyUserCredential originalCredentials) {
        this.setThirdPartyServiceId(originalCredentials.getThirdPartyServiceId());
        this.setUserId(originalCredentials.getUserId());
        this.setAuthenticationScope(originalCredentials.getAuthenticationScope());
        super.copyNonSensitiveProperties(originalCredentials);
    }

    public String getId() {
        return ThirdPartyUserCredential.getId(this.thirdPartyServiceId, this.userId, this.authenticationScope);
    }

    public static String getId(ThirdPartyService thirdPartyService, String userId) {
        return ThirdPartyUserCredential.getId(thirdPartyService.getId(), userId, thirdPartyService.getAuthenticationScope());
    }

    public static String getId(String serviceId, String userId, ThirdPartyAuthenticationScope scope) {
        if (scope != null) {
            switch (scope) {
                case SERVICE: {
                    return serviceId;
                }
                case USER: {
                    return serviceId + userId;
                }
            }
        }
        return "";
    }

    public void setId(String id) {
        this.thirdPartyServiceId = id.substring(0, 36);
        this.authenticationScope = ThirdPartyAuthenticationScope.SERVICE;
        if (id.length() >= 72) {
            this.userId = id.substring(36, 72);
            this.authenticationScope = ThirdPartyAuthenticationScope.USER;
        }
    }

    public String getThirdPartyServiceId() {
        return this.thirdPartyServiceId;
    }

    public void setThirdPartyServiceId(String thirdPartyServiceId) {
        this.thirdPartyServiceId = thirdPartyServiceId;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public ThirdPartyAuthenticationScope getAuthenticationScope() {
        return this.authenticationScope;
    }

    public void setAuthenticationScope(ThirdPartyAuthenticationScope authenticationScope) {
        this.authenticationScope = authenticationScope;
    }
}

