/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public abstract class UserCredential
implements Cloneable {
    @Schema(description="Stale")
    private boolean stale;
    @Schema(description="Signed-In")
    protected boolean signedIn;
    @Schema(description="Expired")
    protected boolean expired;
    @Schema(description="Username", example="john@example.com")
    private String username;
    @Schema(description="Password")
    private String password;
    private String token;
    @Schema(description="Access Token Expiry Date", example="1693584652821")
    private Long tokenExpiryDate;
    @Schema(description="Access Token Last Refresh Date", example="1693584652821")
    private Long tokenLastRefreshDate;
    private String refreshToken;
    private Map<String, String> properties;

    public UserCredential clone() {
        try {
            UserCredential clone = (UserCredential)super.clone();
            HashMap<String, String> properties = new HashMap<String, String>();
            if (this.properties != null) {
                properties.putAll(this.properties);
            }
            clone.setProperties(properties);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public abstract UserCredential cloneNonSensitive();

    public void copyNonSensitiveProperties(UserCredential originalCredential) {
        this.setUsername(originalCredential.getUsername());
        this.setExpired(originalCredential.getExpired());
        this.setStale(originalCredential.getStale());
        this.setTokenExpiryDate(originalCredential.getTokenExpiryDate());
        this.setTokenLastRefreshDate(originalCredential.getTokenLastRefreshDate());
        this.setUsername(originalCredential.getUsername());
        if (originalCredential.getPassword() != null) {
            this.setPassword("**********");
        }
        if (originalCredential.getToken() != null) {
            this.setToken("**********");
        }
        if (originalCredential.getProperties() != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (Map.Entry<String, String> entry : originalCredential.getProperties().entrySet()) {
                properties.put(entry.getKey(), "**********");
            }
            this.setProperties(properties);
        }
        this.updateSignedIn();
    }

    public void setOidcTokenResponse(Map<String, Object> tokenResponse) {
        Object tokenExpiresIn;
        this.setToken((String)tokenResponse.get("access_token"));
        if (tokenResponse.containsKey("refresh_token")) {
            this.setRefreshToken((String)tokenResponse.get("refresh_token"));
        }
        long expiresIn = (tokenExpiresIn = tokenResponse.get("expires_in")) instanceof Number ? ((Number)tokenExpiresIn).longValue() : Long.parseLong((String)tokenExpiresIn);
        long expiryDate = DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + expiresIn * 1000L;
        this.setTokenExpiryDate(expiryDate);
    }

    public void signOut() {
        this.refreshToken = null;
        this.token = null;
        this.tokenExpiryDate = null;
        this.tokenLastRefreshDate = null;
        this.username = null;
        this.password = null;
        this.stale = false;
        this.properties = null;
        this.updateSignedIn();
    }

    public boolean getSignedIn() {
        this.updateSignedIn();
        return this.signedIn;
    }

    public boolean getExpired() {
        this.updateExpired();
        return this.expired;
    }

    public void updateSignedIn() {
        this.signedIn = this.username != null || this.getToken() != null || this.getProperties() != null && !this.getProperties().isEmpty() || this.getPassword() != null;
    }

    protected void updateExpired() {
        this.expired = this.tokenExpiryDate != null ? DateTime.now((DateTimeZone)DateTimeZone.UTC).getMillis() + 300000L >= this.tokenExpiryDate : false;
    }

    public boolean getStale() {
        return this.stale;
    }

    public void setStale(boolean stale) {
        this.stale = stale;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Long getTokenExpiryDate() {
        return this.tokenExpiryDate;
    }

    public void setTokenExpiryDate(Long tokenExpiryDate) {
        this.tokenExpiryDate = tokenExpiryDate;
    }

    public Long getTokenLastRefreshDate() {
        return this.tokenLastRefreshDate;
    }

    public void setTokenLastRefreshDate(Long tokenLastRefreshDate) {
        this.tokenLastRefreshDate = tokenLastRefreshDate;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

