/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.thirdparty;

import com.nuix.automate.utils.exceptions.ResponseException;
import com.nuix.automate.utils.general.ExceptionUtils;
import com.nuix.automate.utils.general.FormattingUtils;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyAuthenticationMethod;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyService;
import com.nuix.automate.utils.models.api.thirdparty.ThirdPartyUserCredential;
import com.nuix.automate.utils.models.api.thirdparty.VeritoneUserCredential;
import com.nuix.automate.utils.models.internal.veritone.VeritoneEngine;
import com.nuix.automate.utils.models.internal.veritone.VeritoneTranscriptionEngine;
import com.nuix.automate.utils.models.internal.veritone.VeritoneTranslationEngine;
import com.nuix.automate.utils.workflow.ParameterType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.core.Response;

public class VeritoneService
extends ThirdPartyService {
    @Schema(description="URL", example="http://10.30.48.10:9000")
    private String url;
    @Schema(description="Parallel Job Submissions", example="64")
    private Integer parallelJobSubmissions;
    @Schema(description="Output Writer Engine")
    private VeritoneEngine owEngine;
    @Schema(description="Translation Engines")
    private List<VeritoneTranslationEngine> translationEngines;
    @Schema(description="Transcription Engines")
    private List<VeritoneTranscriptionEngine> transcriptionEngines;

    @Override
    public void isValid(boolean edit) throws ResponseException {
        super.isValid(edit);
        if (!edit || this.url != null) {
            this.url = FormattingUtils.getNonEmptyTrimmedText(this.url);
            if (this.url == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("UrlMissing"), Response.Status.BAD_REQUEST));
            }
        }
        if (!(edit && this.parallelJobSubmissions == null || this.parallelJobSubmissions != null && this.parallelJobSubmissions >= 1)) {
            throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidParallelJobSubmissions"), Response.Status.BAD_REQUEST));
        }
        if (!edit || this.owEngine != null) {
            if (this.owEngine == null) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("OwEngineMissing"), Response.Status.BAD_REQUEST));
            }
            if (!this.owEngine.isValid()) {
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidEngine"), Response.Status.BAD_REQUEST));
            }
        }
        if (this.translationEngines != null) {
            for (VeritoneEngine veritoneEngine : this.translationEngines) {
                if (veritoneEngine.isValid()) continue;
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidVeritoneTranslationEngines"), Response.Status.BAD_REQUEST));
            }
        }
        if (this.transcriptionEngines != null) {
            for (VeritoneEngine veritoneEngine : this.transcriptionEngines) {
                if (veritoneEngine.isValid()) continue;
                throw new ResponseException(ExceptionUtils.toResponse(this.getUiTranslationKey("InvalidVeritoneTranscriptionEngines"), Response.Status.BAD_REQUEST));
            }
        }
    }

    @Override
    public void update(ThirdPartyService thirdPartyService) {
        super.update(thirdPartyService);
        VeritoneService veritoneService = (VeritoneService)thirdPartyService;
        if (veritoneService.getParallelJobSubmissions() != null) {
            this.setParallelJobSubmissions(veritoneService.getParallelJobSubmissions());
        }
        if (veritoneService.getOwEngine() != null) {
            this.setOwEngine(veritoneService.getOwEngine());
        }
        if (veritoneService.getTranslationEngines() != null) {
            this.setTranslationEngines(veritoneService.getTranslationEngines());
        }
        if (veritoneService.getTranscriptionEngines() != null) {
            this.setTranscriptionEngines(veritoneService.getTranscriptionEngines());
        }
    }

    @Override
    public boolean updateUserCredentialSensitiveFields(ThirdPartyService thirdPartyService) {
        boolean userCredentialStale = super.updateUserCredentialSensitiveFields(thirdPartyService);
        VeritoneService veritoneService = (VeritoneService)thirdPartyService;
        if (veritoneService.getUrl() != null) {
            userCredentialStale = userCredentialStale || !veritoneService.getUrl().equals(this.url);
            this.setUrl(veritoneService.getUrl());
        }
        return userCredentialStale;
    }

    @Override
    public void normalize() {
        if (this.url != null) {
            this.url = this.url.trim();
            try {
                this.url = FormattingUtils.getUrlFromHostname(this.url);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (this.owEngine != null) {
            this.owEngine.normalize();
        }
        if (this.translationEngines != null) {
            for (VeritoneEngine veritoneEngine : this.translationEngines) {
                veritoneEngine.normalize();
            }
        }
        if (this.transcriptionEngines != null) {
            for (VeritoneEngine veritoneEngine : this.transcriptionEngines) {
                veritoneEngine.normalize();
            }
        }
    }

    @Override
    public ThirdPartyService cloneLimited() {
        VeritoneService clone = (VeritoneService)super.cloneLimited();
        clone.cloneEngines(this);
        return clone;
    }

    @Override
    public ThirdPartyService clone() {
        VeritoneService clone = (VeritoneService)super.clone();
        clone.cloneEngines(this);
        return clone;
    }

    private void cloneEngines(VeritoneService veritoneService) {
        this.translationEngines = new ArrayList<VeritoneTranslationEngine>();
        if (veritoneService.getTranslationEngines() != null) {
            this.translationEngines.addAll(veritoneService.getTranslationEngines());
        }
        this.transcriptionEngines = new ArrayList<VeritoneTranscriptionEngine>();
        if (veritoneService.getTranscriptionEngines() != null) {
            this.transcriptionEngines.addAll(veritoneService.getTranscriptionEngines());
        }
    }

    @Override
    public ThirdPartyUserCredential initializeDefaultUserCredential() {
        return new VeritoneUserCredential();
    }

    @Override
    public String getDefaultParameterName() {
        return "{veritone_service_id}";
    }

    @Override
    public ParameterType getParameterType() {
        return ParameterType.VERITONE_SERVICE;
    }

    @Override
    public List<ThirdPartyAuthenticationMethod> getAllowedAuthenticationMethods() {
        return Arrays.asList(ThirdPartyAuthenticationMethod.API_KEY);
    }

    @Override
    public String getPrintableServiceType() {
        return "Veritone";
    }

    public String getUrl() {
        return this.url;
    }

    public Integer getParallelJobSubmissions() {
        return this.parallelJobSubmissions;
    }

    public VeritoneEngine getOwEngine() {
        return this.owEngine;
    }

    public List<VeritoneTranslationEngine> getTranslationEngines() {
        return this.translationEngines;
    }

    public List<VeritoneTranscriptionEngine> getTranscriptionEngines() {
        return this.transcriptionEngines;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setParallelJobSubmissions(Integer parallelJobSubmissions) {
        this.parallelJobSubmissions = parallelJobSubmissions;
    }

    public void setOwEngine(VeritoneEngine owEngine) {
        this.owEngine = owEngine;
    }

    public void setTranslationEngines(List<VeritoneTranslationEngine> translationEngines) {
        this.translationEngines = translationEngines;
    }

    public void setTranscriptionEngines(List<VeritoneTranscriptionEngine> transcriptionEngines) {
        this.transcriptionEngines = transcriptionEngines;
    }
}

