/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.user;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.nuix.automate.utils.models.api.user.UserAccountPlatform;
import com.nuix.automate.utils.models.api.user.UserAccountState;
import com.nuix.automate.utils.models.api.userservice.UserServiceObject;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class UserAccount
implements UserServiceObject,
Cloneable,
Comparable<UserAccount> {
    @Schema(description="User Account ID", example="11111111-1111-1111-1111-111111111111")
    private String id;
    @Schema(description="Authentication Service ID", example="11111111-1111-1111-1111-111111111111")
    private String userServiceId;
    @Schema(description="User Account Platform")
    private UserAccountPlatform platform;
    @Schema(description="User Account Name", example="John Smith")
    private String name;
    @Schema(description="User Account Email", example="jsmith@example.com")
    private String email;
    @Schema(description="User Account State")
    private UserAccountState userAccountState;
    @Schema(description="User Account Attributes")
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public String getNonNullAttributeValue(String key) {
        Object value;
        if (this.attributes != null && (value = this.attributes.get(key)) != null) {
            return String.valueOf(value);
        }
        return "";
    }

    @Override
    public UserAccount clone() {
        try {
            Object obj = super.clone();
            UserAccount userAccount = (UserAccount)obj;
            userAccount.id = this.id;
            userAccount.userServiceId = this.userServiceId;
            userAccount.platform = this.platform;
            userAccount.name = this.name;
            userAccount.email = this.email;
            userAccount.userAccountState = this.userAccountState;
            userAccount.attributes = new HashMap<String, Object>();
            if (this.attributes != null) {
                userAccount.attributes.putAll(this.attributes);
            }
            return userAccount;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public UserServiceObject toDbObject() {
        return this.clone();
    }

    @Override
    public UserServiceObjectType getObjectType() {
        return UserServiceObjectType.USER_ACCOUNT;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public UserAccountPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(UserAccountPlatform platform) {
        this.platform = platform;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @JsonIgnore
    public boolean hasEmail() {
        return this.email != null && this.email.trim().length() > 0;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getUserServiceId() {
        return this.userServiceId;
    }

    @Override
    public void setUserServiceId(String userServiceId) {
        this.userServiceId = userServiceId;
    }

    @Override
    public String getText() {
        return this.email;
    }

    @Override
    public String sortKey() {
        if (this.email == null) {
            return "";
        }
        if (this.email.startsWith(".")) {
            return this.email.substring(1);
        }
        return this.email;
    }

    public UserAccountState getUserAccountState() {
        return this.userAccountState;
    }

    public void setUserAccountState(UserAccountState userAccountState) {
        this.userAccountState = userAccountState;
    }

    @Override
    public int compareTo(@NotNull UserAccount o) {
        if (this.email != null) {
            if (o.getEmail() != null) {
                return this.email.compareTo(o.getEmail());
            }
            return -1;
        }
        if (o.getEmail() != null) {
            return 1;
        }
        if (this.name != null && o.getName() != null) {
            return this.name.compareTo(o.getName());
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        UserAccount u = (UserAccount)obj;
        return this.id.equals(u.id) && (this.userServiceId == null && u.userServiceId == null || this.userServiceId != null && this.userServiceId.equals(u.userServiceId)) && (this.platform == null && u.platform == null || this.platform != null && this.platform.equals((Object)u.platform)) && (this.name == null && u.name == null || this.name != null && this.name.equals(u.name)) && (this.email == null && u.email == null || this.email != null && this.email.equals(u.email)) && (this.userAccountState == null && u.userAccountState == null || this.userAccountState != null && this.userAccountState.equals((Object)u.userAccountState));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.userServiceId, this.platform, this.name, this.email, this.userAccountState});
    }

    public String toString() {
        return "UserAccount " + this.id;
    }
}

