/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.userservice;

import com.nuix.automate.utils.models.api.userservice.UserServiceObject;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.googleapi.ChatSpace;
import java.util.Objects;

public class GoogleChatSpace
implements UserServiceObject {
    private String id;
    private String name;
    private String displayName;
    private String userServiceId;

    public GoogleChatSpace() {
    }

    public GoogleChatSpace(ChatSpace chatSpace) {
        this.name = chatSpace.getName();
        this.displayName = chatSpace.getDisplayName();
        if (this.name != null) {
            this.id = this.name.replace("spaces/", "");
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getText() {
        return this.name + this.displayName;
    }

    @Override
    public String sortKey() {
        return this.getText();
    }

    @Override
    public GoogleChatSpace clone() {
        try {
            return (GoogleChatSpace)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public UserServiceObject toDbObject() {
        GoogleChatSpace dbChatSpace = this.clone();
        dbChatSpace.setId(null);
        dbChatSpace.setUserServiceId(null);
        return dbChatSpace;
    }

    @Override
    public UserServiceObjectType getObjectType() {
        return UserServiceObjectType.GOOGLE_CHAT_SPACE;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getUserServiceId() {
        return this.userServiceId;
    }

    @Override
    public void setUserServiceId(String userServiceId) {
        this.userServiceId = userServiceId;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        GoogleChatSpace chatSpace = (GoogleChatSpace)obj;
        return this.name.equals(chatSpace.name) && (this.userServiceId == null && chatSpace.userServiceId == null || this.userServiceId != null && this.userServiceId.equals(chatSpace.userServiceId)) && (this.displayName == null && chatSpace.displayName == null || this.displayName != null && this.displayName.equals(chatSpace.displayName));
    }

    public int hashCode() {
        return Objects.hash(this.userServiceId, this.name, this.displayName);
    }

    public String toString() {
        return "Google ChatSpace " + this.getId();
    }
}

