/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.userservice;

import com.nuix.automate.utils.models.api.userservice.UserServiceObject;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.googleapi.Group;
import java.util.Objects;

public class GoogleGroup
implements UserServiceObject {
    private String id;
    private String userServiceId;
    private String name;
    private String email;

    public GoogleGroup() {
    }

    public GoogleGroup(Group group) {
        this.id = group.getId();
        this.name = group.getName();
        this.email = group.getEmail();
    }

    @Override
    public String getText() {
        return this.email + this.name;
    }

    @Override
    public String sortKey() {
        return this.getText();
    }

    @Override
    public GoogleGroup clone() {
        try {
            return (GoogleGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public UserServiceObject toDbObject() {
        GoogleGroup dbGroup = this.clone();
        dbGroup.setId(null);
        dbGroup.setUserServiceId(null);
        return dbGroup;
    }

    @Override
    public UserServiceObjectType getObjectType() {
        return UserServiceObjectType.GOOGLE_GROUP;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getUserServiceId() {
        return this.userServiceId;
    }

    @Override
    public void setUserServiceId(String userServiceId) {
        this.userServiceId = userServiceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        GoogleGroup group = (GoogleGroup)obj;
        return this.id.equals(group.id) && (this.userServiceId == null && group.userServiceId == null || this.userServiceId != null && this.userServiceId.equals(group.userServiceId)) && (this.name == null && group.name == null || this.name != null && this.name.equals(group.name)) && (this.email == null && group.email == null || this.email != null && this.email.equals(group.email));
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userServiceId, this.name, this.email);
    }

    public String toString() {
        return "Google Group " + this.getId();
    }
}

