/*
 * Decompiled with CFR 0.152.
 */
package com.nuix.automate.utils.models.api.userservice;

import com.nuix.automate.utils.models.api.userservice.UserServiceObject;
import com.nuix.automate.utils.models.api.userservice.UserServiceObjectType;
import com.nuix.automate.utils.models.internal.googleapi.OrgUnit;
import java.util.Objects;

public class GoogleOrgUnit
implements UserServiceObject {
    private String id;
    private String userServiceId;
    private String name;
    private String path;

    public GoogleOrgUnit() {
    }

    public GoogleOrgUnit(OrgUnit orgUnit) {
        this.id = orgUnit.getOrgUnitId();
        this.name = orgUnit.getName();
        this.path = orgUnit.getOrgUnitPath();
    }

    @Override
    public String getText() {
        return this.path + this.name;
    }

    @Override
    public String sortKey() {
        return this.getText();
    }

    @Override
    public GoogleOrgUnit clone() {
        try {
            return (GoogleOrgUnit)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public UserServiceObject toDbObject() {
        GoogleOrgUnit dbGroup = this.clone();
        dbGroup.setId(null);
        dbGroup.setUserServiceId(null);
        return dbGroup;
    }

    @Override
    public UserServiceObjectType getObjectType() {
        return UserServiceObjectType.GOOGLE_ORG_UNIT;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getUserServiceId() {
        return this.userServiceId;
    }

    @Override
    public void setUserServiceId(String userServiceId) {
        this.userServiceId = userServiceId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        GoogleOrgUnit orgUnit = (GoogleOrgUnit)obj;
        return this.id.equals(orgUnit.id) && (this.userServiceId == null && orgUnit.userServiceId == null || this.userServiceId != null && this.userServiceId.equals(orgUnit.userServiceId)) && (this.name == null && orgUnit.name == null || this.name != null && this.name.equals(orgUnit.name)) && (this.path == null && orgUnit.path == null || this.path != null && this.path.equals(orgUnit.path));
    }

    public int hashCode() {
        return Objects.hash(this.id, this.userServiceId, this.name, this.path);
    }

    public String toString() {
        return "Google OrgUnit " + this.getId();
    }
}

